/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.viewfile.internal.macro;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xwiki.macros.viewfile.internal.macro.StaticBlockWrapperFactory;
import com.xwiki.macros.viewfile.internal.macro.ViewFileExternalBlockManager;
import com.xwiki.macros.viewfile.internal.macro.ViewFileResourceManager;
import com.xwiki.macros.viewfile.macro.ViewFileDisplay;
import com.xwiki.macros.viewfile.macro.ViewFileMacroParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(roles={ViewFileMacroPrepareBlocks.class})
@Singleton
public class ViewFileMacroPrepareBlocks {
    private static final String PPT = "ppt";
    private static final String PPTX = "pptx";
    private static final String ODP = "odp";
    private static final Set<String> OFFICE_FILE_EXTENSIONS = Set.of("ppt", "pptx", "odp", "doc", "docx", "odt", "xls", "xlsx", "ods");
    private static final Set<String> PRESENTATION_FILE_EXTENSIONS = Set.of("ppt", "pptx", "odp");
    private static final LocalDocumentReference PDF_VIEWER_REFERENCE = new LocalDocumentReference(List.of("XWiki"), "PDFViewerMacro");
    private static final LocalDocumentReference COLLABORA_REFERENCE = new LocalDocumentReference(List.of("Collabora", "Code"), "Configuration");
    private static final String PDF = "pdf";
    private static final String PX = "px";
    private static final String CLASS = "class";
    private static final String STYLE = "style";
    private static final String DOWNLOAD = "download";
    private static final String DEFAULT_WIDTH = "100%";
    private static final String DEFAULT_HEIGHT = "1000";
    private static final String ERROR_MACRO_ID = "error";
    private boolean isOversize;
    private boolean inEditMode;
    private String base64;
    @Inject
    private ViewFileExternalBlockManager viewFileExternalBlockManager;
    @Inject
    private ViewFileResourceManager viewFileResourceManager;
    @Inject
    private ContextualLocalizationManager contextLocalization;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;

    public List<Block> prepareBlocks(ViewFileMacroParameters parameters, MacroTransformationContext context, AttachmentReference attachmentReference, String base64, boolean isOversize, boolean inEditMode) throws Exception {
        this.viewFileResourceManager.injectBaseResources();
        this.isOversize = isOversize;
        this.base64 = base64;
        this.inEditMode = inEditMode;
        if (parameters.getDisplay() == ViewFileDisplay.full) {
            return this.prepareFullDisplay(parameters, context, attachmentReference.getName(), attachmentReference);
        }
        return this.prepareCompactDisplay(parameters, context, attachmentReference.getName(), attachmentReference);
    }

    public List<Block> errorMessage(MacroTransformationContext context, String key) {
        String message = this.contextLocalization.getTranslationPlain(key, new Object[0]);
        return List.of(new MacroBlock(ERROR_MACRO_ID, new HashMap(), message, context.isInline()));
    }

    private List<Block> prepareCompactDisplay(ViewFileMacroParameters parameters, MacroTransformationContext context, String fileName, AttachmentReference attachmentReference) throws Exception {
        String fileExtension = this.getFileExtension(fileName);
        this.applyPresentationResourcesIfNeeded(fileExtension);
        boolean hasPreview = this.hasPreview(fileExtension);
        boolean forceCardView = this.shouldForceCardView(parameters.getDisplay(), context.isInline());
        boolean inLineElement = this.inEditMode || context.isInline();
        boolean thumbnailStyle = false;
        String style = "";
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)parameters.getWidth())) {
            stringBuilder.append(String.format(" width:%s;", parameters.getWidth()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.getHeight())) {
            stringBuilder.append(String.format(" height:%s;", parameters.getHeight()));
        }
        if (stringBuilder.length() > 0) {
            style = stringBuilder.toString();
            thumbnailStyle = false;
        } else if (forceCardView && this.inEditMode) {
            style = "width: min-content; min-height: min-content;";
            thumbnailStyle = false;
        } else {
            thumbnailStyle = !forceCardView;
        }
        String thumbnailType = thumbnailStyle ? "Button" : "Card";
        String buttonClass = thumbnailStyle ? "button button-primary" : "";
        Map<String, String> rootElementParameters = Map.of(CLASS, String.format("viewFileThumbnail viewFileThumbnail%s", thumbnailType), STYLE, style, "data-preview", Boolean.toString(hasPreview), "data-ref", (String)this.referenceSerializer.serialize((EntityReference)attachmentReference, new Object[0]));
        Map<String, String> linkElementParameters = Map.of(DOWNLOAD, DOWNLOAD, CLASS, buttonClass, "title", this.contextLocalization.getTranslationPlain("rendering.macro.viewFile.thumbnail.button.title", new Object[0]));
        List<Block> innerContainer = this.getFileDisplayBlocks(thumbnailStyle, inLineElement, attachmentReference);
        ResourceReference reference = new ResourceReference((String)this.referenceSerializer.serialize((EntityReference)attachmentReference, new Object[0]), ResourceType.ATTACHMENT);
        LinkBlock linkBlock = new LinkBlock(innerContainer, reference, false, linkElementParameters);
        ArrayList<Block> innerBlocks = new ArrayList<Block>();
        innerBlocks.add((Block)linkBlock);
        if (this.isApplicationInstalled(COLLABORA_REFERENCE)) {
            Block collaboraBlock = this.viewFileExternalBlockManager.getCollaboraBlock();
            innerBlocks.add(collaboraBlock);
        }
        Block wrapperBlock = StaticBlockWrapperFactory.constructBlockWrapper(inLineElement, innerBlocks, rootElementParameters);
        return List.of(wrapperBlock);
    }

    private Block getImageThumbnail(boolean isSpan) {
        String imageAltTranslation = this.contextLocalization.getTranslationPlain("rendering.macro.viewFile.thumbnail.button.image.alt", new Object[0]);
        String overlayTextTranslation = this.contextLocalization.getTranslationPlain("rendering.macro.viewFile.thumbnail.button.overlay", new Object[0]);
        String imageBase64 = "data:image/jpeg;base64," + this.base64;
        ResourceReference reference = new ResourceReference(imageBase64, ResourceType.DATA);
        ImageBlock imageBlock = new ImageBlock(reference, false, Map.of(CLASS, "viewfile-thumbnail-image", "alt", imageAltTranslation));
        FormatBlock overlayText = new FormatBlock(List.of(new WordBlock(overlayTextTranslation)), Format.NONE, Map.of(CLASS, "overlay-text"));
        Block overlay = StaticBlockWrapperFactory.constructBlockWrapper(isSpan, List.of(overlayText), Map.of(CLASS, "overlay"));
        Block imageContainer = StaticBlockWrapperFactory.constructBlockWrapper(isSpan, List.of(imageBlock, overlay), Map.of(CLASS, "image-container"));
        return imageContainer;
    }

    private List<Block> prepareFullDisplay(ViewFileMacroParameters parameters, MacroTransformationContext context, String fileName, AttachmentReference attachmentReference) throws Exception {
        if (this.inEditMode || this.isOversize || context.isInline()) {
            return this.prepareCompactDisplay(parameters, context, fileName, attachmentReference);
        }
        String fileExtension = this.getFileExtension(fileName);
        if (OFFICE_FILE_EXTENSIONS.contains(fileExtension)) {
            return this.prepareOfficeFile(fileExtension, parameters, attachmentReference, "");
        }
        if (fileExtension.equalsIgnoreCase(PDF) && this.isApplicationInstalled(PDF_VIEWER_REFERENCE)) {
            return this.preparePDF(fileName, parameters);
        }
        return this.prepareCompactDisplay(parameters, context, fileName, attachmentReference);
    }

    private List<Block> preparePDF(String fileName, ViewFileMacroParameters parameters) {
        String width = this.processDimensionsUnit(parameters.getWidth(), DEFAULT_WIDTH, false);
        String height = this.processDimensionsUnit(parameters.getHeight(), DEFAULT_HEIGHT, false);
        return List.of(new MacroBlock("pdfviewer", Map.of("file", fileName, "height", height, "width", width), false));
    }

    private List<Block> prepareOfficeFile(String fileExtension, ViewFileMacroParameters parameters, AttachmentReference attachmentReference, String content) {
        String width = this.processDimensionsUnit(parameters.getWidth(), DEFAULT_WIDTH, true);
        String height = this.processDimensionsUnit(parameters.getHeight(), "1000px", true);
        MacroBlock officeMacroBlock = new MacroBlock("office", Collections.singletonMap("reference", (String)this.referenceSerializer.serialize((EntityReference)attachmentReference, new Object[0])), content, false);
        String style = String.format("width:%s; height:%s; overflow:auto", width, height);
        String elementClass = "viewFileFull " + (PRESENTATION_FILE_EXTENSIONS.contains(fileExtension) ? "box" : "");
        GroupBlock groupBlock = new GroupBlock(List.of(officeMacroBlock), Map.of(CLASS, elementClass, STYLE, style));
        return List.of(groupBlock);
    }

    private boolean isApplicationInstalled(LocalDocumentReference localDocumentReference) throws XWikiException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        DocumentReference viewerWikiRef = new DocumentReference(localDocumentReference, context.getWikiReference());
        return context.getWiki().exists(viewerWikiRef, context);
    }

    private String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
    }

    private boolean hasPreview(String fileExtension) throws XWikiException {
        return fileExtension.equals(PDF) && this.isApplicationInstalled(PDF_VIEWER_REFERENCE) || OFFICE_FILE_EXTENSIONS.contains(fileExtension) && !this.isOversize;
    }

    private boolean shouldForceCardView(ViewFileDisplay display, boolean context) {
        return display == ViewFileDisplay.thumbnail || display == ViewFileDisplay.full || display == null && !context;
    }

    private void applyPresentationResourcesIfNeeded(String fileExtension) {
        if (PRESENTATION_FILE_EXTENSIONS.contains(fileExtension)) {
            this.viewFileResourceManager.injectPresentationResources();
        }
    }

    private List<Block> getFileDisplayBlocks(boolean thumbnailStyle, boolean isSpan, AttachmentReference attachmentReference) throws Exception {
        Block thumbunalBlock = this.getThumbnail(thumbnailStyle, attachmentReference, isSpan);
        WordBlock titleTextBlock = new WordBlock(attachmentReference.getName());
        FormatBlock titleBlock = new FormatBlock(List.of(titleTextBlock), Format.NONE, Map.of(CLASS, "viewFileName"));
        return List.of(thumbunalBlock, titleBlock);
    }

    private Block getThumbnail(boolean thumbnailStyle, AttachmentReference attachmentReference, boolean isSpan) throws Exception {
        if (this.base64 != null && !this.base64.isEmpty() && !thumbnailStyle) {
            return this.getImageThumbnail(isSpan);
        }
        return this.viewFileExternalBlockManager.getMimeTypeBlock(attachmentReference, thumbnailStyle || isSpan);
    }

    private String processDimensionsUnit(String value, String defaultValue, boolean addUnit) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (addUnit) {
                boolean hasUnit = value.endsWith("%") || value.endsWith(PX);
                return hasUnit ? value : value + PX;
            }
            return value.endsWith(PX) ? StringUtils.removeEnd((String)value, (String)PX) : value;
        }
        return defaultValue;
    }
}

