/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.viewfile.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;

@Component(roles={AttachmentSizeValidator.class})
@Singleton
public class AttachmentSizeValidator {
    private static final int MAX_ENTRY_LENGTH = 100000000;
    private static final List<String> OLD_OFFICE_EXTENSIONS = List.of("doc", "xls", "ppt");
    private static final int MAX_PARAGRAPHS = 200000;
    @Inject
    private Provider<XWikiContext> wikiContextProvider;
    @Inject
    private Logger logger;

    public boolean isAttachmentOversize(AttachmentReference attachRef) throws XWikiException, IOException {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        XWikiDocument document = wikiContext.getWiki().getDocument(attachRef.getDocumentReference(), wikiContext);
        XWikiAttachment attachment = document.getAttachment(attachRef.getName());
        if (attachment == null) {
            return true;
        }
        String extension = attachRef.getName().substring(attachRef.getName().lastIndexOf(46) + 1).toLowerCase();
        boolean isOversize = false;
        if (!OLD_OFFICE_EXTENSIONS.contains(extension)) {
            InputStream is = attachment.getContentInputStream(wikiContext);
            isOversize = this.containsOversizeEntry(is);
        }
        return isOversize;
    }

    private boolean containsOversizeEntry(InputStream file) throws IOException {
        int maxEntrySize = IOUtils.getMaxByteArrayInitSize();
        if (maxEntrySize == -1) {
            maxEntrySize = 100000000;
        }
        try (ZipInputStream zis = new ZipInputStream(file);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                switch (entry.getName()) {
                    case "docProps/app.xml": {
                        if (!this.exceedsParagraphLimit(zis, "<Paragraphs>(\\d+)</Paragraphs>", "<Paragraphs>")) break;
                        boolean bl = true;
                        return bl;
                    }
                    case "meta.xml": {
                        if (!this.exceedsParagraphLimit(zis, "meta:paragraph-count\\s*=\\s*\"(\\d+)\"", "paragraph-count")) break;
                        boolean bl = true;
                        return bl;
                    }
                    default: {
                        long entrySize = entry.getSize();
                        if (entry.getSize() == -1L) {
                            entrySize = this.getEntrySize(zis);
                        }
                        if (entrySize <= (long)maxEntrySize) break;
                        this.logger.warn("File entry size is larger then the maximum length for this record type set at [{}].", (Object)maxEntrySize);
                        boolean bl = true;
                        return bl;
                    }
                }
                zis.closeEntry();
            }
        }
        return false;
    }

    private boolean exceedsParagraphLimit(ZipInputStream zis, String regex, String selector) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(zis));
        while ((line = reader.readLine()) != null) {
            Pattern pattern;
            Matcher matcher;
            if (!line.contains(selector) || !(matcher = (pattern = Pattern.compile(regex)).matcher(line)).find()) continue;
            try {
                int paragraphCount = Integer.parseInt(matcher.group(1));
                if (paragraphCount <= 200000) continue;
                this.logger.warn("File oversize: too many paragraphs ({}).", (Object)paragraphCount);
                return true;
            }
            catch (NumberFormatException e) {
                this.logger.error("Failed to subtract the number of paragraphs. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return false;
    }

    private long getEntrySize(ZipInputStream zis) throws IOException {
        int read;
        long size = 0L;
        byte[] buffer = new byte[8192];
        while ((read = zis.read(buffer)) != -1) {
            size += (long)read;
        }
        return size;
    }
}

