/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.rendering.block.match.OrBlockMatcher;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="promacroexpand")
@Unstable
public class ExpandScriptService
implements ScriptService {
    private static final String PLAIN_1_0 = "plain/1.0";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;

    public String getAutoTitle(String content, String syntaxId) {
        XDOM xdom;
        Parser parser;
        if (content == null || content.isEmpty()) {
            return null;
        }
        try {
            parser = (Parser)((ComponentManager)this.componentManagerProvider.get()).getInstance(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Could not find a parser for syntax [{}]", (Object)syntaxId, (Object)e);
            return null;
        }
        try {
            xdom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            this.logger.error("Could not parse content", (Throwable)e);
            return null;
        }
        List candidates = xdom.getBlocks((BlockMatcher)new OrBlockMatcher(new BlockMatcher[]{new ClassBlockMatcher(HeaderBlock.class), new MacroBlockMatcher("panel")}), Block.Axes.DESCENDANT);
        for (Block candidate : candidates) {
            if (candidate instanceof MacroBlock) {
                MacroBlock panel = (MacroBlock)candidate;
                String title = panel.getParameter("title");
                if (title == null) {
                    String panelContent = panel.getContent();
                    title = this.getAutoTitle(panelContent, syntaxId);
                }
                if (title == null) continue;
                return title;
            }
            if (candidate instanceof HeaderBlock) {
                DefaultWikiPrinter printer = new DefaultWikiPrinter();
                try {
                    BlockRenderer renderer = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, PLAIN_1_0);
                    renderer.render((Collection)candidate.getChildren(), (WikiPrinter)printer);
                    return printer.toString();
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Could not find the plain/1.0 renderer", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        return null;
    }
}

