/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.excerptinclude.internal.macro;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.MacroRefactoring;
import org.xwiki.rendering.macro.MacroRefactoringException;

@Component
@Singleton
@Named(value="excerpt-include")
public class ExcerptIncludeMacroRefactoring
implements MacroRefactoring {
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    @Named(value="macro")
    private EntityReferenceResolver<String> macroEntityReferenceResolver;

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, DocumentReference sourceReference, DocumentReference targetReference, boolean relative) throws MacroRefactoringException {
        return this.getMacroBlock(macroBlock, currentDocumentReference, sourceReference, targetReference);
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, AttachmentReference sourceReference, AttachmentReference targetReference, boolean relative) throws MacroRefactoringException {
        return this.getMacroBlock(macroBlock, currentDocumentReference, sourceReference, targetReference);
    }

    public Set<ResourceReference> extractReferences(MacroBlock macroBlock) {
        DocumentResourceReference resourceReference = new DocumentResourceReference(macroBlock.getParameter("0"));
        return Collections.singleton(resourceReference);
    }

    private <T extends EntityReference> Optional<MacroBlock> getMacroBlock(MacroBlock macroBlock, DocumentReference currentDocumentReference, T sourceReference, T targetReference) {
        String stringMacroReference = macroBlock.getParameter("0");
        if (StringUtils.isNotEmpty((CharSequence)stringMacroReference)) {
            boolean resolvedRelative;
            MacroBlock newMacroBlock = (MacroBlock)macroBlock.clone();
            EntityReference macroReference = this.macroEntityReferenceResolver.resolve((Object)stringMacroReference, EntityType.DOCUMENT, new Object[]{macroBlock, sourceReference});
            boolean bl = resolvedRelative = !this.isReferenceAbsolute(stringMacroReference, macroReference);
            if (macroReference.equals(sourceReference)) {
                newMacroBlock.setParameter("0", this.serializeTargetReference(targetReference, (EntityReference)currentDocumentReference, resolvedRelative));
                return Optional.of(newMacroBlock);
            }
        }
        return Optional.empty();
    }

    private String serializeTargetReference(EntityReference newTargetReference, EntityReference currentReference, boolean relative) {
        return relative ? (String)this.compactEntityReferenceSerializer.serialize(newTargetReference, new Object[]{currentReference}) : (String)this.compactWikiEntityReferenceSerializer.serialize(newTargetReference, new Object[]{currentReference.extractReference(EntityType.WIKI)});
    }

    private boolean isReferenceAbsolute(String referenceRepresentation, EntityReference absoluteEntityReference) {
        return ((String)this.compactWikiEntityReferenceSerializer.serialize(absoluteEntityReference, new Object[]{absoluteEntityReference.extractReference(EntityType.WIKI)})).equals(referenceRepresentation);
    }
}

