/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.viewfile.internal.macro;

import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.viewfile.internal.AttachmentSizeValidator;
import com.xwiki.macros.viewfile.internal.ThumbnailGenerator;
import com.xwiki.macros.viewfile.internal.macro.StaticBlockWrapperFactory;
import com.xwiki.macros.viewfile.internal.macro.ViewFileMacroPrepareBlocks;
import com.xwiki.macros.viewfile.macro.ViewFileMacroParameters;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="view-file")
@Singleton
public class ViewFileMacro
extends AbstractProMacro<ViewFileMacroParameters> {
    @Inject
    protected ContextualAuthorizationManager contextualAuthorization;
    private boolean isOversize;
    private String base64;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> attachmentReferenceResolver;
    @Inject
    private AttachmentSizeValidator attachmentSizeValidator;
    @Inject
    private ThumbnailGenerator thumbnailGenerator;
    @Inject
    private ViewFileMacroPrepareBlocks viewFileMacroPrepareBlocks;

    public ViewFileMacro() {
        super("View file", "Show a file using PDF Viewer Macro or Office Viewer.", ViewFileMacroParameters.class);
    }

    @Override
    public List<Block> internalExecute(ViewFileMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        try {
            String fileName = this.resolveFileName(parameters);
            if (StringUtils.isBlank((CharSequence)fileName)) {
                return this.viewFileMacroPrepareBlocks.errorMessage(context, "rendering.macro.viewFile.attachmentrequired");
            }
            AttachmentReference attachmentRef = this.createAttachmentReference(fileName);
            if (!this.userCanView(attachmentRef)) {
                return this.viewFileMacroPrepareBlocks.errorMessage(context, "rendering.macro.viewFile.norights");
            }
            boolean oversize = this.attachmentSizeValidator.isAttachmentOversize(attachmentRef);
            String base64Thumbnail = oversize ? null : this.generateThumbnailBase64(attachmentRef);
            return List.of(StaticBlockWrapperFactory.constructBlockWrapper(context.isInline(), this.viewFileMacroPrepareBlocks.prepareBlocks(parameters, context, attachmentRef, base64Thumbnail, oversize, this.inEditMode(context)), new HashMap<String, String>()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private AttachmentReference createAttachmentReference(String fileName) {
        return new AttachmentReference((EntityReference)this.attachmentReferenceResolver.resolve((Object)fileName, new Object[]{EntityType.ATTACHMENT}));
    }

    private boolean userCanView(AttachmentReference attachmentRef) {
        return this.contextualAuthorization.hasAccess(Right.VIEW, (EntityReference)attachmentRef);
    }

    private String generateThumbnailBase64(AttachmentReference attachmentRef) {
        byte[] thumbnailData = this.thumbnailGenerator.getThumbnailData(attachmentRef);
        return Base64.getEncoder().encodeToString(thumbnailData);
    }

    private String resolveFileName(ViewFileMacroParameters parameters) {
        if (StringUtils.isNotBlank((CharSequence)parameters.getName())) {
            return parameters.getName();
        }
        return parameters.getAttFilename();
    }

    private boolean inEditMode(MacroTransformationContext context) {
        SyntaxType targetSyntaxType;
        Syntax syntax = context.getTransformationContext().getTargetSyntax();
        boolean editMode = syntax == null ? this.inEditModeFallBack() : SyntaxType.ANNOTATED_HTML.equals((Object)(targetSyntaxType = syntax.getType())) || SyntaxType.ANNOTATED_XHTML.equals((Object)targetSyntaxType);
        return editMode;
    }

    private boolean inEditModeFallBack() {
        String syntax = (String)this.scriptContextManager.getScriptContext().getAttribute("syntaxType");
        return syntax != null && (syntax.equals("annotatedhtml") || syntax.equals("annotatedxhtml"));
    }
}

