/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.viewfile.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.ExternalOfficeManager;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.officeimporter.server.OfficeServerConfiguration;

@Component(roles={ThumbnailGenerator.class})
@Singleton
public class ThumbnailGenerator {
    public static final String THUMBNAILS_PATH = "viewfilemacro/thumbnails/";
    private static final List<String> OFFICE_EXTENSIONS = List.of("odp", "doc", "docx", "odt", "xls", "xlsx", "ods");
    private static final String PPT_EXTENSION = "ppt";
    private static final String PPTX_EXTENSION = "pptx";
    private static final List<String> PRESENTATION_EXTENSIONS = List.of("ppt", "pptx");
    private static final String JPG_EXTENSION = ".jpg";
    private static final String JPG = "jpg";
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private Provider<XWikiContext> wikiContextProvider;
    @Inject
    private OfficeServerConfiguration officeServerConfig;
    @Inject
    private OfficeServer officeServer;

    public byte[] getThumbnailData(AttachmentReference attachmentReference) {
        try {
            if (this.isOfficeServerConnected()) {
                File thumbnail = this.getThumbnailPath(attachmentReference);
                if (!thumbnail.exists()) {
                    return this.generateAndGetThumbnailBytes(attachmentReference);
                }
                return Files.readAllBytes(thumbnail.toPath());
            }
            this.logger.warn("Unable to generate thumbnail byte data. Office server is not connected.");
            return new byte[0];
        }
        catch (Exception e) {
            this.logger.error("There was an error while attempting to get the thumbnail byte data. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return new byte[0];
        }
    }

    private byte[] generateAndGetThumbnailBytes(AttachmentReference attachmentReference) throws Exception {
        String extension = this.getExtension(attachmentReference.getName());
        if (OFFICE_EXTENSIONS.contains(extension)) {
            return this.getOfficeThumbnailBytes(attachmentReference);
        }
        if (PRESENTATION_EXTENSIONS.contains(extension)) {
            return this.getPresentationThumbnailBytes(attachmentReference, extension);
        }
        if (extension.equals("pdf")) {
            return this.getPDFThumbnailBytes(attachmentReference);
        }
        this.logger.warn("Extension type not supported.");
        return new byte[0];
    }

    private byte[] getPDFThumbnailBytes(AttachmentReference attachmentReference) throws Exception {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        XWikiDocument document = wikiContext.getWiki().getDocument(attachmentReference.getDocumentReference(), wikiContext);
        InputStream is = document.getAttachment(attachmentReference.getName()).getContentInputStream(wikiContext);
        return this.generateThumbnail(new ByteArrayInputStream(is.readAllBytes()), attachmentReference);
    }

    private byte[] getOfficeThumbnailBytes(AttachmentReference attachmentReference) throws Exception {
        ByteArrayInputStream bais = this.getPDFContent(attachmentReference);
        return this.generateThumbnail(bais, attachmentReference);
    }

    private ByteArrayInputStream getPDFContent(AttachmentReference attachmentReference) throws Exception {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        XWikiDocument document = wikiContext.getWiki().getDocument(attachmentReference.getDocumentReference(), wikiContext);
        try (InputStream is = document.getAttachment(attachmentReference.getName()).getContentInputStream(wikiContext);){
            ByteArrayInputStream byteArrayInputStream;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ExternalOfficeManager manager = ((ExternalOfficeManager.Builder)ExternalOfficeManager.builder().portNumbers(this.officeServerConfig.getServerPorts()).taskExecutionTimeout(Long.valueOf(10000L))).build();
                manager.start();
                LocalConverter.make((OfficeManager)manager).convert(is).to((OutputStream)baos).as(DefaultDocumentFormatRegistry.PDF).execute();
                manager.stop();
                byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            return byteArrayInputStream;
        }
    }

    private byte[] generateThumbnail(ByteArrayInputStream inputStream, AttachmentReference attachmentReference) throws Exception {
        PDDocument document = PDDocument.load((InputStream)inputStream);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 150.0f);
        BufferedImage resized = Thumbnails.of((BufferedImage[])new BufferedImage[]{bim}).size(150, 212).asBufferedImage();
        File thumbnailFile = this.getThumbnailPath(attachmentReference);
        ImageIO.write((RenderedImage)resized, JPG, thumbnailFile);
        document.close();
        return Files.readAllBytes(thumbnailFile.toPath());
    }

    private byte[] getPresentationThumbnailBytes(AttachmentReference attachmentReference, String extension) throws Exception {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        XWikiDocument document = wikiContext.getWiki().getDocument(attachmentReference.getDocumentReference(), wikiContext);
        try (InputStream is = document.getAttachment(attachmentReference.getName()).getContentInputStream(wikiContext);){
            switch (extension) {
                case "ppt": {
                    HSLFSlideShow ppt = new HSLFSlideShow(is);
                    byte[] byArray = this.getSlideThumbnail(ppt, attachmentReference);
                    return byArray;
                }
                case "pptx": {
                    XMLSlideShow pptx = new XMLSlideShow(is);
                    byte[] byArray = this.getSlideThumbnail(pptx, attachmentReference);
                    return byArray;
                }
            }
            this.logger.warn("Failed to identify the presentation file extension.");
            byte[] byArray = new byte[]{};
            return byArray;
        }
    }

    private byte[] getSlideThumbnail(HSLFSlideShow ppt, AttachmentReference attachmentReference) throws IOException {
        HSLFSlide slide = (HSLFSlide)ppt.getSlides().get(0);
        int width = ppt.getPageSize().width;
        int height = ppt.getPageSize().height;
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        slide.draw(graphics);
        return this.getSlideBytes(attachmentReference, img);
    }

    private byte[] getSlideThumbnail(XMLSlideShow ppt, AttachmentReference attachmentReference) throws IOException {
        XSLFSlide slide = (XSLFSlide)ppt.getSlides().get(0);
        int width = ppt.getPageSize().width;
        int height = ppt.getPageSize().height;
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        slide.draw(graphics);
        return this.getSlideBytes(attachmentReference, img);
    }

    private byte[] getSlideBytes(AttachmentReference attachmentReference, BufferedImage img) throws IOException {
        BufferedImage resized = Thumbnails.of((BufferedImage[])new BufferedImage[]{img}).size(150, 212).asBufferedImage();
        File outputFile = this.getThumbnailPath(attachmentReference);
        ImageIO.write((RenderedImage)resized, JPG, outputFile);
        return Files.readAllBytes(outputFile.toPath());
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
    }

    private boolean isOfficeServerConnected() {
        this.officeServer.refreshState();
        return this.officeServer.getState() == OfficeServer.ServerState.CONNECTED;
    }

    private File getThumbnailPath(AttachmentReference attachmentReference) {
        File tempDir = new File(this.environment.getTemporaryDirectory(), THUMBNAILS_PATH);
        String encodedFileReference = URLEncoder.encode(attachmentReference.toString(), StandardCharsets.UTF_8);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return new File(tempDir, encodedFileReference + JPG_EXTENSION);
    }
}

