/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.viewfile.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AbstractAttachmentEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ViewFileMacroAttachmentEventListener")
@Singleton
public class AttachmentModificationListener
extends AbstractEventListener
implements Initializable {
    public static final String HINT = "ViewFileMacroAttachmentEventListener";
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private AttachmentReferenceResolver<String> attachmentResolver;

    public AttachmentModificationListener() {
        super(HINT, new Event[]{new AttachmentDeletedEvent(), new AttachmentUpdatedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document;
        if ((event instanceof AttachmentUpdatedEvent || event instanceof AttachmentDeletedEvent) && (document = (XWikiDocument)source) != null) {
            this.removeThumbnail(((AbstractAttachmentEvent)event).getName(), document);
        }
    }

    public void initialize() throws InitializationException {
        this.deleteOldFormat();
    }

    private void removeThumbnail(String attachmentName, XWikiDocument document) {
        File tempDir = new File(this.environment.getTemporaryDirectory(), "viewfilemacro/thumbnails/");
        AttachmentReference attachmentReference = this.attachmentResolver.resolve((Object)attachmentName, new Object[]{document.getDocumentReference()});
        String encodedFileReference = URLEncoder.encode(attachmentReference.toString(), StandardCharsets.UTF_8);
        File thumbnail = new File(tempDir, encodedFileReference + ".jpg");
        if (thumbnail.exists()) {
            if (thumbnail.delete()) {
                this.logger.info("Successfully removed thumbnail at location: [{}]", (Object)thumbnail.getPath());
            } else {
                this.logger.warn("Failed to remove thumbnail at location: [{}]", (Object)thumbnail.getPath());
            }
        }
    }

    private void deleteOldFormat() {
        File tempDir = new File(this.environment.getTemporaryDirectory(), "viewfilemacro/thumbnails/");
        if (tempDir.exists()) {
            for (File oldFolder : tempDir.listFiles()) {
                if (!oldFolder.isDirectory()) continue;
                AttachmentModificationListener.fileDelete(oldFolder);
            }
        }
    }

    private static void fileDelete(File oldFolder) {
        File[] children;
        if (oldFolder.isDirectory() && (children = oldFolder.listFiles()) != null) {
            for (File child : children) {
                AttachmentModificationListener.fileDelete(child);
            }
        }
        oldFolder.delete();
    }
}

