/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.userlist.internal.macro;

import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.internal.grouplist.GroupReferenceList;
import com.xwiki.macros.internal.userlist.UserReferenceList;
import com.xwiki.macros.userlist.macro.UserListMacroParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.displayer.HTMLDisplayerException;
import org.xwiki.displayer.HTMLDisplayerManager;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.text.StringUtils;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserManager;
import org.xwiki.wiki.user.WikiUserManagerException;

@Component
@Named(value="userList")
@Singleton
public class UserListMacro
extends AbstractProMacro<UserListMacroParameters> {
    private static final String XWIKI_DOT = "XWiki.";
    @Inject
    private HTMLDisplayerManager htmlDisplayerManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private WikiUserManager wikiUserManager;
    @Inject
    private DocumentReferenceResolver<String> resolver;

    public UserListMacro() {
        super("User list", "Displays a custom list of users with their avatar", UserListMacroParameters.class);
    }

    private void addUsersFromWiki(UserReferenceList users, String wiki, List<String> groups) throws QueryException {
        Query query;
        if (groups.isEmpty()) {
            query = this.queryManager.createQuery("select doc.fullName from Document doc, doc.object(XWiki.XWikiUsers) obj order by doc.fullName", "xwql");
        } else {
            query = this.queryManager.createQuery("select g.member from Document doc, doc.object(XWiki.XWikiGroups) g where doc.fullName in (:groups) and g.member <> ''order by g.member", "xwql");
            query.bindValue("groups", groups);
        }
        List results = query.setWiki(wiki).execute();
        for (String userName : results) {
            users.add(this.resolver.resolve((Object)UserListMacro.ensureFullUserRef(wiki, userName), new Object[0]));
        }
    }

    private static String ensureFullUserRef(String wiki, String userName) {
        Object userRef = userName;
        if (!((String)userRef).contains(XWIKI_DOT)) {
            userRef = XWIKI_DOT + (String)userRef;
        }
        if (!((String)userRef).contains(":XWiki.")) {
            userRef = wiki + ":" + (String)userRef;
        }
        return userRef;
    }

    @Override
    public List<Block> internalExecute(UserListMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            GroupReferenceList groupReferences;
            params.put("properties", StringUtils.join(parameters.getProperties(), (char)','));
            params.put("fixedTableLayout", String.valueOf(parameters.isFixedTableLayout()));
            UserReferenceList users = parameters.getUsers();
            if (users == null) {
                users = new UserReferenceList();
            }
            if ((groupReferences = parameters.getGroups()) == null) {
                groupReferences = new GroupReferenceList();
            }
            ArrayList<String> groups = new ArrayList<String>();
            for (EntityReference group : groupReferences) {
                groups.add((String)this.localSerializer.serialize(group, new Object[0]));
            }
            String mainWiki = this.getWikiDescriptorManager().getMainWikiId();
            String currentWiki = this.getWikiDescriptorManager().getCurrentWikiId();
            if (!groups.isEmpty() || users.isEmpty()) {
                if (mainWiki.equals(currentWiki)) {
                    this.addUsersFromWiki(users, mainWiki, groups);
                } else {
                    UserScope userScope = this.wikiUserManager.getUserScope(currentWiki);
                    switch (userScope) {
                        case GLOBAL_ONLY: {
                            this.addUsersFromWiki(users, mainWiki, groups);
                            break;
                        }
                        case LOCAL_ONLY: {
                            this.addUsersFromWiki(users, currentWiki, groups);
                            break;
                        }
                        default: {
                            this.addUsersFromWiki(users, mainWiki, groups);
                            this.addUsersFromWiki(users, currentWiki, groups);
                        }
                    }
                }
            }
            String html = this.htmlDisplayerManager.display(UserReferenceList.class, (Object)users, params, "view");
            return Arrays.asList(new RawBlock(html, Syntax.HTML_5_0));
        }
        catch (HTMLDisplayerException | QueryException | WikiUserManagerException e) {
            throw new MacroExecutionException("Failed to render the userProfile viewer template.", e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }
}

