/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.tab.internal;

import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.tab.macro.TabMacroParameters;
import com.xwiki.macros.tab.macro.TransitionEffect;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.validation.EntityNameValidation;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.text.StringUtils;

@Component
@Named(value="tab")
@Singleton
public class TabMacro
extends AbstractProMacro<TabMacroParameters> {
    private static final String NAME = "Tab";
    private static final String DESCRIPTION = "Tab element for the tab group macro. This is expected to be put as the tab-group macro content.";
    private static final String CONTENT_DESCRIPTION = "The content to be displayed in the tab.";
    private static final String BLOCK_PARAM_CLASS = "class";
    @Inject
    protected MacroContentParser contentParser;
    @Inject
    @Named(value="SlugEntityNameValidation")
    private EntityNameValidation slugEntityNameValidation;
    @Inject
    @Named(value="ssrx")
    private SkinExtension ssrx;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;

    public TabMacro() {
        super(NAME, DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, true, Block.LIST_BLOCK_TYPE), TabMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return false;
    }

    @Override
    protected List<Block> internalExecute(TabMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        SyntaxType targetSyntaxType;
        Syntax syntax = context.getTransformationContext().getTargetSyntax();
        SyntaxType syntaxType = targetSyntaxType = syntax == null ? null : syntax.getType();
        if (SyntaxType.ANNOTATED_HTML.equals((Object)targetSyntaxType) || SyntaxType.ANNOTATED_XHTML.equals((Object)targetSyntaxType)) {
            List tabLabelBlock;
            this.ssrx.use("css/tabmacro.css");
            try {
                tabLabelBlock = this.plainTextParser.parse((Reader)new StringReader(parameters.getLabel())).getChildren();
            }
            catch (Exception e) {
                throw new MacroExecutionException("Can't get tab label", (Throwable)e);
            }
            if (!tabLabelBlock.isEmpty()) {
                ((Block)tabLabelBlock.get(0)).setParameter(BLOCK_PARAM_CLASS, "tabs-edit-title");
            }
            List children = this.contentParser.parse(content, context, false, context.isInline()).getChildren();
            MetaDataBlock editableContent = new MetaDataBlock(children, this.getNonGeneratedContentMetaData());
            LinkedList<Block> result = new LinkedList<Block>();
            result.add((Block)new GroupBlock(tabLabelBlock, Map.of(BLOCK_PARAM_CLASS, "tabs-edit-title-block")));
            result.add((Block)editableContent);
            return result;
        }
        List macroContent = this.contentParser.parse(content, context, false, context.isInline()).getChildren();
        String divClass = "tab-pane" + (String)(StringUtils.isEmpty((CharSequence)parameters.getCssClass()) ? "" : " " + parameters.getCssClass()) + (parameters.isShowByDefault() ? " active" : "") + (parameters.getEffectType() == TransitionEffect.FADE ? (parameters.isShowByDefault() ? " fade in" : " fade") : "");
        GroupBlock groupBlock = new GroupBlock(macroContent, Map.of("role", "tabpanel", BLOCK_PARAM_CLASS, divClass, "data-next-after", Integer.toString(parameters.getNextAfter())));
        if (StringUtils.isNotEmpty((CharSequence)parameters.getId())) {
            groupBlock.setParameter("id", this.slugEntityNameValidation.transform(parameters.getId()));
        }
        StringBuilder cssStyle = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)parameters.getCssStyle())) {
            cssStyle.append(parameters.getCssStyle());
        }
        if (parameters.getEffectDuration() != 0) {
            cssStyle.append("transition-duration: ");
            cssStyle.append(parameters.getEffectDuration());
            cssStyle.append("s;");
        }
        if (StringUtils.isNotEmpty((CharSequence)cssStyle.toString())) {
            groupBlock.setParameter("style", cssStyle.toString());
        }
        return Collections.singletonList(groupBlock);
    }
}

