/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.tab.internal;

import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.tab.macro.TabGroupMacroParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.validation.EntityNameValidation;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.text.StringUtils;
import org.xwiki.xml.XMLUtils;

@Component
@Named(value="tab-group")
@Singleton
public class TabGroupMacro
extends AbstractProMacro<TabGroupMacroParameters> {
    private static final String NAME = "Tab group";
    private static final String DESCRIPTION = "The main macro which group tab macro elements.";
    private static final String CONTENT_DESCRIPTION = "It's expected that the content of this macro are only tab macro. Note all other element will be ignored. Only tab macro element will be rendered.";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ID = "id";
    private static final String TAB_MACRO_ID = "tab";
    private static final String TAB_MACRO_PARAM_LABEL = "label";
    private static final String BLOCK_PARAM_CLASS = "class";
    private static final String BLOCK_PARAM_ROLE = "role";
    private static final String PARAM_NAME_NEXT_AFTER = "nextAfter";
    private static final String PARAM_NAME_EFFECT = "effectType";
    private static final String PARAM_NAME_EFFECT_DURATION = "effectDuration";
    private static final String CSS_DELIMITER = ";";
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="ssrx")
    private SkinExtension ssrx;
    @Inject
    @Named(value="jsrx")
    private SkinExtension jsrx;
    @Inject
    @Named(value="SlugEntityNameValidation")
    private EntityNameValidation slugEntityNameValidation;

    public TabGroupMacro() {
        super(NAME, DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false, Block.LIST_BLOCK_TYPE), TabGroupMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return false;
    }

    private List<Block> renderView(TabGroupMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        this.ssrx.use("css/tabmacro.css");
        this.jsrx.use("js/tabmacro.js");
        String macroId = parameters.getId();
        if (StringUtils.isEmpty((CharSequence)macroId)) {
            macroId = context.getXDOM().getIdGenerator().generateUniqueId("tab-group");
        }
        macroId = this.slugEntityNameValidation.transform(macroId);
        XDOM contentBlocks = this.contentParser.parse(content, context, false, context.isInline());
        ArrayList<ListItemBlock> ulBlocks = new ArrayList<ListItemBlock>();
        List macroBlocks = contentBlocks.getBlocks((BlockMatcher)new MacroBlockMatcher(TAB_MACRO_ID), Block.Axes.CHILD);
        Optional<Block> defaultTabBlock = macroBlocks.stream().filter(i -> TRUE.equals(i.getParameter("default"))).findFirst();
        int defaultTabIndex = defaultTabBlock.isPresent() ? macroBlocks.indexOf(defaultTabBlock.get()) : 0;
        int inc = 0;
        for (Block mb : macroBlocks) {
            boolean isActive = inc == defaultTabIndex;
            mb.setParameter("default", isActive ? TRUE : FALSE);
            Object id = mb.getParameter(ID);
            if (id == null) {
                id = macroId + "_" + inc;
                mb.setParameter(ID, (String)id);
            }
            if (parameters.getEffectType() != null && mb.getParameter(PARAM_NAME_EFFECT) == null) {
                mb.setParameter(PARAM_NAME_EFFECT, parameters.getEffectType().name());
            }
            if (parameters.getEffectDuration() != 0 && mb.getParameter(PARAM_NAME_EFFECT_DURATION) == null) {
                mb.setParameter(PARAM_NAME_EFFECT_DURATION, Integer.toString(parameters.getEffectDuration()));
            }
            HashMap<String, String> lbParam = new HashMap<String, String>();
            lbParam.put(BLOCK_PARAM_ROLE, "presentation");
            if (isActive) {
                lbParam.put(BLOCK_PARAM_CLASS, "active");
            }
            String escapedId = XMLUtils.escape((String)this.slugEntityNameValidation.transform((String)id));
            RawBlock linkBlock = new RawBlock(String.format("<a href=\"#%s\" aria-controls=\"%s\" role=\"tab\" data-toggle=\"tab\">%s</a>", escapedId, escapedId, XMLUtils.escape((String)mb.getParameter(TAB_MACRO_PARAM_LABEL))), Syntax.HTML_5_0);
            ulBlocks.add(new ListItemBlock(Collections.singletonList(linkBlock), lbParam));
            ++inc;
        }
        HashMap<String, String> mainBlockParam = new HashMap<String, String>();
        StringBuilder style = new StringBuilder();
        LinkedList<String> mainDivClasses = new LinkedList<String>();
        mainDivClasses.add("xwikitabmacro");
        if (StringUtils.isNotEmpty((CharSequence)parameters.getId())) {
            mainBlockParam.put(ID, parameters.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getWidth())) {
            style.append("width: ").append(parameters.getWidth()).append(CSS_DELIMITER);
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getHeight())) {
            style.append("height: ").append(parameters.getHeight()).append(CSS_DELIMITER);
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getCssClass())) {
            mainDivClasses.add(parameters.getCssClass());
        }
        if (parameters.getTabLocation() != null && parameters.getTabLocation() != TabGroupMacroParameters.Location.TOP) {
            switch (parameters.getTabLocation()) {
                case RIGHT: {
                    mainDivClasses.add("tabs-right");
                    break;
                }
                case LEFT: {
                    mainDivClasses.add("tabs-left");
                    break;
                }
                case BOTTOM: {
                    mainDivClasses.add("tabs-below");
                    break;
                }
                case NONE: {
                    mainDivClasses.add("tabs-none");
                    break;
                }
            }
        }
        mainBlockParam.put("style", style.toString());
        mainBlockParam.put(BLOCK_PARAM_CLASS, String.join((CharSequence)" ", mainDivClasses));
        BulletedListBlock tabElementBlock = new BulletedListBlock(ulBlocks, Map.of(BLOCK_PARAM_CLASS, "nav nav-tabs", BLOCK_PARAM_ROLE, "tablist"));
        mainBlockParam.put("data-next-after", Integer.toString(parameters.getNextAfter()));
        mainBlockParam.put("data-loop-cards", Boolean.toString(parameters.isLoopCards()));
        GroupBlock tabContentBlock = new GroupBlock(macroBlocks, Map.of(BLOCK_PARAM_CLASS, "tab-content"));
        List<Block> blockList = parameters.getTabLocation() == TabGroupMacroParameters.Location.BOTTOM ? Arrays.asList(tabContentBlock, tabElementBlock) : Arrays.asList(tabElementBlock, tabContentBlock);
        GroupBlock result = new GroupBlock(blockList, mainBlockParam);
        return Collections.singletonList(result);
    }

    @Override
    protected List<Block> internalExecute(TabGroupMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        SyntaxType targetSyntaxType;
        Syntax syntax = context.getTransformationContext().getTargetSyntax();
        SyntaxType syntaxType = targetSyntaxType = syntax == null ? null : syntax.getType();
        if (SyntaxType.ANNOTATED_HTML.equals((Object)targetSyntaxType) || SyntaxType.ANNOTATED_XHTML.equals((Object)targetSyntaxType)) {
            List children = this.contentParser.parse(content, context, false, context.isInline()).getChildren();
            MetaDataBlock editableContent = new MetaDataBlock(children, this.getNonGeneratedContentMetaData());
            return Collections.singletonList(editableContent);
        }
        return this.renderView(parameters, content, context);
    }
}

