/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.EventInstance;
import org.xwiki.contrib.moccacalendar.EventSource;
import org.xwiki.contrib.moccacalendar.RecurrentEventGenerator;
import org.xwiki.contrib.moccacalendar.internal.DefaultSourceConfigurationClassInitializer;
import org.xwiki.contrib.moccacalendar.internal.Utils;
import org.xwiki.contrib.moccacalendar.internal.utils.DefaultEventAssembly;
import org.xwiki.contrib.moccacalendar.internal.utils.EventQuery;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Named(value="moccacalendar")
@Singleton
@Component
public class MoccaCalendarScriptService
implements ScriptService {
    private static final String CALENDAR_BASE_QUERY = ", BaseObject as obj where doc.fullName=obj.name and doc.name!='MoccaCalendarTemplate' and obj.className='MoccaCalendar.MoccaCalendarClass' order by doc.title, doc.name";
    private static final String MOCCA_CALENDAR_EVENT_TEMPLATE = "MoccaCalendar.MoccaCalendarEventTemplate";
    private static final LocalDocumentReference GLOBAL_SETTINGS_PAGE = new LocalDocumentReference(Arrays.asList("MoccaCalendar", "Code"), "GlobalSettings");
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> stringDocRefResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private QueryManager queryManager;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    @Named(value="hidden")
    private QueryFilter hidden;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;
    @Inject
    @Named(value="viewable")
    private QueryFilter viewableFilter;
    @Inject
    private Map<String, RecurrentEventGenerator> eventGenerators;
    @Inject
    private Map<String, EventSource> eventSources;
    @Inject
    private DefaultEventAssembly eventAssembly;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    public List<DocumentReference> getAllCalendars() {
        List calenderRefs = Collections.emptyList();
        try {
            Query query = this.queryManager.createQuery(CALENDAR_BASE_QUERY, "hql").addFilter(this.hidden);
            query.addFilter(this.documentFilter);
            query.addFilter(this.viewableFilter);
            calenderRefs = query.execute();
        }
        catch (QueryException qe) {
            this.logger.error("error while fetching calendars", (Throwable)qe);
        }
        return calenderRefs;
    }

    public List<EventInstance> queryEvents(Date dateFrom, Date dateTo, String filter, String parentReference, boolean sortAscending) throws QueryException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        return this.queryEvents(dateFrom, dateTo, filter, context.getWikiId(), parentReference, sortAscending);
    }

    public List<EventInstance> queryEvents(Date dateFrom, Date dateTo, String filter, String wiki, String parentReference, boolean sortAscending) throws QueryException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        if (dateTo == null) {
            dateTo = dateFrom;
        }
        EventQuery eventQuery = new EventQuery("MoccaCalendar.MoccaCalendarEventClass", MOCCA_CALENDAR_EVENT_TEMPLATE, wiki);
        eventQuery.addDateLimits(dateFrom, dateTo);
        eventQuery.addObjectProperty("IntegerProperty", "recurrent").addCondition(" and recurrent.value = 0 ");
        DocumentReference parentRef = parentReference == null ? null : this.stringDocRefResolver.resolve((java.lang.Object)parentReference, new java.lang.Object[0]);
        eventQuery.addLocationFilter(filter, parentRef);
        eventQuery.setAscending(sortAscending);
        List<java.lang.Object> visibleEvents = Collections.emptyList();
        try {
            visibleEvents = this.eventAssembly.executeQuery(eventQuery);
        }
        catch (QueryException qe) {
            this.logger.error("error while fetching regular events", (Throwable)qe);
        }
        ArrayList<EventInstance> events = new ArrayList<EventInstance>();
        for (DocumentReference documentReference : visibleEvents) {
            try {
                XWikiDocument eventDoc = context.getWiki().getDocument(documentReference, context);
                BaseObject eventData = eventDoc.getXObject(eventDoc.resolveClassReference("MoccaCalendar.MoccaCalendarEventClass"));
                if (eventData == null) {
                    this.logger.error("data inconsistency: query returned [{}] which contains no object for [{}]", (java.lang.Object)documentReference, (java.lang.Object)"MoccaCalendar.MoccaCalendarEventClass");
                    continue;
                }
                EventInstance event = new EventInstance();
                Date startDate = eventData.getDateValue("startDate");
                DateTime startDateTime = new DateTime(startDate.getTime());
                event.setStartDate(startDateTime);
                Date endDate = Utils.fetchOrGuessEndDate(eventData);
                DateTime endDateTime = new DateTime(endDate.getTime());
                event.setEndDate(endDateTime);
                this.completeEventData(event, eventDoc, eventData);
                events.add(event);
            }
            catch (XWikiException e) {
                this.logger.warn("cannot find event data [{}]", (java.lang.Object)documentReference, (java.lang.Object)e);
            }
        }
        EventQuery recurrentEventQuery = new EventQuery("MoccaCalendar.MoccaCalendarEventClass", MOCCA_CALENDAR_EVENT_TEMPLATE, wiki);
        recurrentEventQuery.addLocationFilter(filter, parentRef);
        recurrentEventQuery.addObjectProperty("IntegerProperty", "recurrent").addCondition(" and recurrent.value = 1 ");
        try {
            List<DocumentReference> list = this.eventAssembly.executeQuery(recurrentEventQuery);
            List<EventInstance> recurrentEventInstances = this.filterRecurrentEvents(list, dateFrom, dateTo);
            events.addAll(recurrentEventInstances);
        }
        catch (XWikiException | QueryException throwable) {
            this.logger.error("error while fetching recurrent events", throwable);
        }
        for (Map.Entry<String, EventSource> meetings : this.eventSources.entrySet()) {
            List<EventInstance> meetingEvents;
            if (!this.sourceIsActive(meetings, filter, parentRef)) continue;
            this.logger.debug("add events from [{}] source", (java.lang.Object)meetings.getKey());
            if ("wiki".equals(filter) && parentRef == null) {
                try {
                    WikiDescriptor wikiDescriptor = this.wikiDescriptorManager.getById(wiki);
                    parentRef = wikiDescriptor.getMainPageReference();
                }
                catch (WikiManagerException e) {
                    this.logger.error("Could not retrieve wiki descriptor for [{}]", (java.lang.Object)wiki, (java.lang.Object)e);
                }
            }
            if ((meetingEvents = meetings.getValue().getEvents(dateFrom, dateTo, filter, parentRef, sortAscending)) == null) continue;
            for (EventInstance meeting : meetingEvents) {
                this.fillInColorsFromNearestCalendar(meeting);
                meeting.setSource(meetings.getKey());
            }
            events.addAll(meetingEvents);
        }
        this.sortEvents(events, sortAscending);
        return events;
    }

    public List<EventInstance> queryEvents(Date dateFrom, Date dateTo, List<String> wikis, boolean sortAscending) throws QueryException {
        ArrayList<EventInstance> events = new ArrayList<EventInstance>();
        if (wikis != null) {
            for (String wiki : wikis) {
                events.addAll(this.queryEvents(dateFrom, dateTo, "wiki", wiki, null, sortAscending));
            }
            this.sortEvents(events, sortAscending);
        }
        return events;
    }

    private boolean sourceIsActive(Map.Entry<String, EventSource> meetings, String filter, DocumentReference parentRef) {
        boolean locallyEnabled;
        String name = meetings.getKey();
        EventSource source = meetings.getValue();
        this.logger.debug("check if source [{}] is active", (java.lang.Object)name);
        if (!source.isAvailable()) {
            this.logger.debug("source [{}] is unvailable", (java.lang.Object)name);
            return false;
        }
        if (name == null) {
            return true;
        }
        if (!this.isGloballyEnabled(name)) {
            this.logger.debug("source [{}] is globally disabled", (java.lang.Object)name);
            return false;
        }
        this.logger.debug("source [{}] is globally enabled", (java.lang.Object)name);
        if (filter == null || "wiki".equals(filter)) {
            return true;
        }
        try {
            locallyEnabled = this.isLocallyEnabled(name, source, parentRef);
            this.logger.debug("is source [{}] locally enabled: [{}]", (java.lang.Object)name, (java.lang.Object)locallyEnabled);
        }
        catch (XWikiException e) {
            locallyEnabled = false;
            this.logger.warn("could not determine if source [{}] is active", (java.lang.Object)name, (java.lang.Object)e);
        }
        return locallyEnabled;
    }

    private boolean isGloballyEnabled(String sourceName) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        LocalDocumentReference defaultConfigClass = DefaultSourceConfigurationClassInitializer.getConfigurationClass();
        boolean result = false;
        try {
            XWikiDocument globalPrefs = context.getWiki().getDocument((EntityReference)GLOBAL_SETTINGS_PAGE, context);
            BaseObject configObj = globalPrefs.getXObject(new DocumentReference(defaultConfigClass, new WikiReference(context.getWikiId())), "source", sourceName);
            result = this.isActive(configObj);
        }
        catch (XWikiException e) {
            this.logger.warn("cannot load global calendar source settings", (Throwable)e);
        }
        return result;
    }

    private boolean isLocallyEnabled(String name, EventSource source, DocumentReference parentRef) throws XWikiException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        LocalDocumentReference defaultConfigClass = DefaultSourceConfigurationClassInitializer.getConfigurationClass();
        LocalDocumentReference configClass = source.getConfigurationClass();
        XWikiDocument configDoc = context.getWiki().getDocument(parentRef, context);
        this.logger.trace("try config class [{}] in document [{}] for source [{}]", new java.lang.Object[]{configClass, configDoc, name});
        BaseObject configObj = configClass != null ? configDoc.getXObject((EntityReference)configClass) : configDoc.getXObject(new DocumentReference(defaultConfigClass, new WikiReference(context.getWikiId())), "source", name);
        return this.isActive(configObj);
    }

    private boolean isActive(BaseObject configObject) {
        this.logger.trace("check config object [{}] from [{}] for active flag", (java.lang.Object)configObject, configObject != null ? configObject.getReference() : "n/a");
        return configObject != null && configObject.getIntValue("active") == 1;
    }

    public String getDisplaySheetForEvent(EventInstance event) {
        if (event == null || event.getSource() == null) {
            return null;
        }
        return "MoccaCalendar.Code.EventViews.Generic";
    }

    public List<String> getAvailableSources() {
        return this.eventSources.keySet().stream().filter(name -> {
            this.logger.trace("check availability of source [{}]", name);
            return this.eventSources.get(name).isAvailable();
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public Map<String, LocalDocumentReference> getAvailableSourceConfigurations() {
        HashMap<String, LocalDocumentReference> sources = new HashMap<String, LocalDocumentReference>();
        for (Map.Entry<String, EventSource> source : this.eventSources.entrySet()) {
            if (!source.getValue().isAvailable()) continue;
            LocalDocumentReference configClass = source.getValue().getConfigurationClass();
            if (configClass == null) {
                configClass = DefaultSourceConfigurationClassInitializer.getConfigurationClass();
            }
            sources.put(source.getKey(), configClass);
        }
        return sources;
    }

    /*
     * WARNING - void declaration
     */
    private List<EventInstance> filterRecurrentEvents(List<DocumentReference> eventReferences, Date dateFrom, Date dateTo) throws XWikiException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        ArrayList<EventInstance> eventsInstances = new ArrayList<EventInstance>();
        for (DocumentReference eventDocRef : eventReferences) {
            EventInstance modifiedEvent;
            XWikiDocument eventDoc = context.getWiki().getDocument(eventDocRef, context);
            BaseObject eventData = eventDoc.getXObject(eventDoc.resolveClassReference("MoccaCalendar.MoccaCalendarEventClass"));
            BaseObject eventRecData = eventDoc.getXObject(eventDoc.resolveClassReference("MoccaCalendar.Code.MoccaCalendarEventRecurrencyClass"));
            if (eventRecData == null) {
                this.logger.info("found recurrent event [{}] without recurrency information; skipping", (java.lang.Object)eventDocRef);
                continue;
            }
            String eventType = eventRecData.getStringValue("frequency");
            RecurrentEventGenerator generator = this.eventGenerators.get(eventType);
            if (generator == null) {
                this.logger.error("no recurrent event generator found for frequency [{}] used by [{}]", (java.lang.Object)eventType, (java.lang.Object)eventDocRef);
                continue;
            }
            Set<Long> deletions = this.deletedEventsOf(eventDoc);
            Map<Long, EventInstance> modifiedEvents = this.modifiedEventsOf(eventDoc, dateFrom, dateTo);
            for (EventInstance eventInstance : generator.generate(eventDoc, dateFrom, dateTo)) {
                void var16_19;
                if (deletions.contains(eventInstance.getStartDate().getMillis())) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("skip deleted event at {} for doc [{}])", (java.lang.Object)eventInstance.getStartDate(), (java.lang.Object)eventDoc);
                    continue;
                }
                modifiedEvent = modifiedEvents.remove(eventInstance.getStartDate().getMillis());
                if (modifiedEvent != null) {
                    EventInstance eventInstance2 = modifiedEvent;
                }
                var16_19.setRecurrent(true);
                this.completeEventData((EventInstance)var16_19, eventDoc, eventData);
                eventsInstances.add((EventInstance)var16_19);
            }
            if (modifiedEvents.isEmpty()) continue;
            this.logger.info("we dropped some modifications: [{}]", (java.lang.Object)modifiedEvents.size());
            if (!this.logger.isDebugEnabled()) continue;
            for (Map.Entry entry : modifiedEvents.entrySet()) {
                this.logger.debug("event originally started at [{}]", (java.lang.Object)new DateTime(entry.getKey()));
                modifiedEvent = (EventInstance)entry.getValue();
                this.logger.debug("  event start at [{}]", (java.lang.Object)modifiedEvent.getStartDate());
                this.logger.debug("  event end at [{}]", (java.lang.Object)modifiedEvent.getEndDate());
            }
            this.logger.debug("======= end of list of dropped modifications");
        }
        return eventsInstances;
    }

    private void completeEventData(EventInstance event, XWikiDocument eventDoc, BaseObject eventData) throws XWikiException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference eventDocRef = eventDoc.getDocumentReference();
        boolean isAllDay = eventData.getIntValue("allDay") == 1;
        event.setAllDay(isAllDay);
        String textColor = eventData.displayView("textColor", context);
        String backgroundColor = eventData.displayView("backgroundColor", context);
        DateTime endDateExclusive = event.getEndDate();
        if (isAllDay) {
            endDateExclusive = endDateExclusive.plusDays(1);
        }
        event.setEndDateExclusive(endDateExclusive);
        if (null == event.getTitle()) {
            event.setTitle(eventDoc.getRenderedTitle(Syntax.PLAIN_1_0, context));
        }
        if (null == event.getDescription()) {
            Utils.fillDescription(eventData, "description", context, event);
        }
        event.setEventDocRef(eventDocRef);
        event.setModifiable(true);
        event.setMovable(!event.isRecurrent());
        if (event.getBackgroundColor() == null || event.getBackgroundColor().isEmpty()) {
            event.setBackgroundColor(backgroundColor);
        }
        if (event.getTextColor() == null || event.getTextColor().isEmpty()) {
            event.setTextColor(textColor);
        }
        this.fillInColorsFromNearestCalendar(event);
    }

    private void fillInColorsFromNearestCalendar(EventInstance event) {
        try {
            DocumentReference eventDocRef = event.getEventDocRef();
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            String defaultPageName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
            BaseObject calendarData = null;
            SpaceReference parentSpaceRef = null;
            if (defaultPageName.equals(eventDocRef.getName())) {
                EntityReference parentRef = eventDocRef.getLastSpaceReference().getParent();
                if (parentRef != null && parentRef instanceof SpaceReference) {
                    parentSpaceRef = (SpaceReference)parentRef;
                }
            } else {
                parentSpaceRef = eventDocRef.getLastSpaceReference();
            }
            if (parentSpaceRef != null) {
                DocumentReference parentDoc = new DocumentReference(defaultPageName, parentSpaceRef);
                XWikiDocument calendarDoc = context.getWiki().getDocument(parentDoc, context);
                calendarData = calendarDoc.getXObject(calendarDoc.resolveClassReference("MoccaCalendar.MoccaCalendarClass"));
            }
            if (calendarData == null) {
                event.setBackgroundColor("");
                event.setTextColor("");
            } else {
                if (event.getBackgroundColor().isEmpty()) {
                    event.setBackgroundColor(calendarData.displayView("color", context));
                }
                if (event.getTextColor().isEmpty()) {
                    event.setTextColor(calendarData.displayView("textColor", context));
                }
            }
        }
        catch (XWikiException xe) {
            this.logger.warn("could not calculate colors for event", (Throwable)xe);
        }
    }

    public int getModifiedEventObjectIndex(Document eventDoc, Date eventStartDate) {
        List modificationNotices = eventDoc.getDocument().getXObjects(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.Code.MoccaCalendarEventModificationClass", new java.lang.Object[0]));
        if (modificationNotices != null) {
            int n = modificationNotices.size();
            for (int i = 0; i < n; ++i) {
                Date modificationDate;
                BaseObject modificationNotice = (BaseObject)modificationNotices.get(i);
                Date date = modificationDate = modificationNotice == null ? null : modificationNotice.getDateValue("eventOrigStartDate");
                if (!eventStartDate.equals(modificationDate)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object createModificationDummy(Document eventDoc, Date eventStartDate) {
        XWikiDocument xwikiEventDoc = eventDoc.getDocument();
        BaseObject eventData = xwikiEventDoc.getXObject(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.MoccaCalendarEventClass", new java.lang.Object[0]));
        BaseObject modificationData = new BaseObject();
        modificationData.setXClassReference((EntityReference)this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.Code.MoccaCalendarEventModificationClass", new java.lang.Object[0]));
        modificationData.setOwnerDocument(xwikiEventDoc);
        modificationData.setNumber(-1);
        if (eventData != null) {
            Date defaultStartDate = eventStartDate != null ? eventStartDate : eventData.getDateValue("startDate");
            modificationData.setDateValue("startDate", defaultStartDate);
            long baseDuration = this.getBaseDuration(eventData);
            Date defaultEndDate = new Date(defaultStartDate.getTime() + baseDuration);
            modificationData.setDateValue("endDate", defaultEndDate);
            modificationData.setLargeStringValue("description", eventData.getLargeStringValue("description"));
            modificationData.setStringValue("title", xwikiEventDoc.getTitle());
        }
        return new Object(modificationData, (XWikiContext)this.xcontextProvider.get());
    }

    public EventInstance getEventInstance(Document eventDoc, Date eventStartDate, String source) {
        EventSource eventSource = this.eventSources.get(source);
        if (eventSource != null) {
            return eventSource.getEventInstance(eventDoc, eventStartDate);
        }
        return this.getEventInstance(eventDoc, eventStartDate);
    }

    public EventInstance getEventInstance(Document eventDoc, Date eventStartDate) {
        int objIndex;
        Date originalEventStartDate;
        XWikiDocument xwikiEventDoc = eventDoc.getDocument();
        BaseObject eventData = xwikiEventDoc.getXObject(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.MoccaCalendarEventClass", new java.lang.Object[0]));
        EventInstance event = new EventInstance();
        if (eventData == null) {
            return null;
        }
        if (eventStartDate == null) {
            originalEventStartDate = eventData.getDateValue("startDate");
            objIndex = -1;
        } else {
            originalEventStartDate = eventStartDate;
            objIndex = this.getModifiedEventObjectIndex(eventDoc, eventStartDate);
        }
        BaseObject modificationData = null;
        if (objIndex != -1) {
            modificationData = xwikiEventDoc.getXObject(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.Code.MoccaCalendarEventModificationClass", new java.lang.Object[0]), objIndex);
        }
        if (modificationData != null) {
            event = this.createModifiedEventData(xwikiEventDoc, eventData, modificationData, originalEventStartDate, null, null);
        } else {
            long baseDuration = this.getBaseDuration(eventData);
            event.setStartDate(new DateTime(originalEventStartDate.getTime()));
            event.setOriginalStartDate(new DateTime(originalEventStartDate.getTime()));
            event.setEndDate(new DateTime(originalEventStartDate.getTime() + baseDuration));
        }
        try {
            this.completeEventData(event, xwikiEventDoc, eventData);
        }
        catch (XWikiException xe) {
            this.logger.info("could not create modified event data for document [{}] and date [{}]", new java.lang.Object[]{eventDoc, eventStartDate, xe});
        }
        return event;
    }

    private void sortEvents(List<EventInstance> events, final boolean ascending) {
        Collections.sort(events, new Comparator<EventInstance>(){

            @Override
            public int compare(EventInstance event1, EventInstance event2) {
                DateTime startDate1 = event1.getStartDate();
                DateTime startDate2 = event2.getStartDate();
                int result = startDate1 == null ? (startDate2 == null ? 0 : -1) : (startDate2 == null ? 1 : startDate1.compareTo((ReadableInstant)startDate2));
                return ascending ? result : -result;
            }
        });
    }

    private Set<Long> deletedEventsOf(XWikiDocument eventDoc) {
        HashSet<Long> deletions = new HashSet<Long>();
        List deleteNotices = eventDoc.getXObjects(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.Code.MoccaCalendarEventDeletionClass", new java.lang.Object[0]));
        if (deleteNotices != null) {
            for (BaseObject deleteNotice : deleteNotices) {
                Date deleted = deleteNotice == null ? null : deleteNotice.getDateValue("eventOrigStartDate");
                if (deleted == null) continue;
                deletions.add(deleted.getTime());
            }
        }
        if (!deletions.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("found {} deletions for event [{}])", (java.lang.Object)deletions.size(), (java.lang.Object)eventDoc);
        }
        return deletions;
    }

    private Map<Long, EventInstance> modifiedEventsOf(XWikiDocument eventDoc, Date dateFrom, Date dateTo) {
        HashMap<Long, EventInstance> results = new HashMap<Long, EventInstance>();
        List modificationNotices = eventDoc.getXObjects(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.Code.MoccaCalendarEventModificationClass", new java.lang.Object[0]));
        BaseObject eventData = eventDoc.getXObject(this.stringDocRefResolver.resolve((java.lang.Object)"MoccaCalendar.MoccaCalendarEventClass", new java.lang.Object[0]));
        if (modificationNotices != null) {
            int n = modificationNotices.size();
            for (int i = 0; i < n; ++i) {
                EventInstance modifiedInstance;
                Date originalStartDate;
                BaseObject modificationNotice = (BaseObject)modificationNotices.get(i);
                if (modificationNotice == null || (originalStartDate = modificationNotice.getDateValue("eventOrigStartDate")) == null || (modifiedInstance = this.createModifiedEventData(eventDoc, eventData, modificationNotice, originalStartDate, dateFrom, dateTo)) == null) continue;
                results.put(originalStartDate.getTime(), modifiedInstance);
            }
        }
        return results;
    }

    private EventInstance createModifiedEventData(XWikiDocument eventDoc, BaseObject eventData, BaseObject modificationNotice, Date originalStartDate, Date dateFrom, Date dateTo) {
        String modifiedDescription;
        String modifiedTitle;
        Date actualEndDate;
        long baseDuration = this.getBaseDuration(eventData);
        Date originalEndDate = new Date(originalStartDate.getTime() + baseDuration);
        Date actualStartDate = modificationNotice.getDateValue("startDate");
        if (actualStartDate == null) {
            actualStartDate = originalStartDate;
        }
        if ((actualEndDate = modificationNotice.getDateValue("endDate")) == null) {
            if (actualStartDate.equals(originalStartDate)) {
                actualEndDate = originalEndDate;
            } else {
                boolean allDay = eventData.getIntValue("allDay") == 1;
                actualEndDate = Utils.guessEndDate(actualStartDate, allDay);
            }
        }
        if (dateFrom != null && actualEndDate.before(dateFrom) && originalEndDate.before(dateFrom)) {
            return null;
        }
        if (dateTo != null && actualStartDate.after(dateTo) && originalStartDate.after(dateTo)) {
            return null;
        }
        EventInstance modifiedInstance = new EventInstance();
        modifiedInstance.setStartDate(new DateTime(actualStartDate.getTime()));
        modifiedInstance.setOriginalStartDate(new DateTime(originalStartDate.getTime()));
        modifiedInstance.setEndDate(new DateTime(actualEndDate.getTime()));
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        String actualBackgroundColor = modificationNotice.displayView("backgroundColor", context);
        String actualTextColor = modificationNotice.displayView("textColor", context);
        if (actualBackgroundColor != null && !actualBackgroundColor.isEmpty()) {
            modifiedInstance.setBackgroundColor(actualBackgroundColor);
        }
        if (actualTextColor != null && !actualTextColor.isEmpty()) {
            modifiedInstance.setTextColor(actualTextColor);
        }
        if ((modifiedTitle = modificationNotice.displayView("title", context)) != null && !"".equals(modifiedTitle.trim())) {
            modifiedInstance.setTitle(eventDoc.getRenderedContent(modifiedTitle, eventDoc.getSyntax().toIdString(), Syntax.PLAIN_1_0.toIdString(), context));
        }
        if ((modifiedDescription = modificationNotice.getStringValue("description")) != null && !"".equals(modifiedDescription.trim())) {
            Utils.fillDescription(modificationNotice, "description", context, modifiedInstance);
        }
        return modifiedInstance;
    }

    private long getBaseDuration(BaseObject eventData) {
        Date baseStartDate = eventData.getDateValue("startDate");
        Date baseEndDate = Utils.fetchOrGuessEndDate(eventData);
        return baseEndDate.getTime() - baseStartDate.getTime();
    }
}

