/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.migrations;

import com.xpn.xwiki.XWikiException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.migrations.AddReccurrentProperty;
import org.xwiki.query.QueryException;
import org.xwiki.script.service.ScriptService;

@Named(value="moccacalendarmigration")
@Singleton
@Component
public class MoccaCalendarMigrationScriptService
implements ScriptService {
    @Inject
    @Named(value="org.xwiki.contrib.moccacalendar.migrations.AddReccurrentProperty")
    private AddReccurrentProperty recurrentMigrator;
    @Inject
    private Logger logger;

    public long countUnmigratedEventsForRecurrency() {
        try {
            long allEvents = this.recurrentMigrator.countAllEvents();
            long migratedEvents = this.recurrentMigrator.countMigratedEvents();
            return allEvents - migratedEvents;
        }
        catch (QueryException e) {
            this.logger.warn("could not execute queries to count unmigrated events", (Throwable)e);
            return -1L;
        }
    }

    public Map<String, Object> migrateEventsForRecurrenty(int offset, int limit) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            int count = this.recurrentMigrator.addRecurrentPropertyToEvents(offset, limit);
            results.put("migrationCount", count);
        }
        catch (XWikiException | QueryException e) {
            this.logger.error("failure to migrate events", e);
            results.put("errorMessage", e.getLocalizedMessage());
        }
        return results;
    }
}

