/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.migrations;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.AbstractWikiEvent;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.EndFoldEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.event.filter.EventFilter;
import org.xwiki.observation.event.filter.RegexEventFilter;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroFactory;
import org.xwiki.rendering.macro.wikibridge.WikiMacroManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Named(value="org.xwiki.contrib.moccacalendar.migrations.AddReccurrentProperty")
@Singleton
@Component(roles={AddReccurrentProperty.class, EventListener.class})
public class AddReccurrentProperty
implements EventListener {
    private static final EventFilter OLD_MACRO_LOCATION = new RegexEventFilter("[^:]*:MoccaCalendar.Macro");
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionInstalledEvent(), new ExtensionUpgradedEvent(), new DocumentDeletedEvent(OLD_MACRO_LOCATION));
    private static final List<Event> EVENTS_STARTUP = Arrays.asList(new ApplicationReadyEvent(), new WikiReadyEvent(), new ExtensionUpgradedEvent(), new DocumentDeletedEvent(OLD_MACRO_LOCATION));
    @Inject
    private WikiDescriptorManager wikiManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private WikiMacroFactory macroFactory;
    @Inject
    private WikiMacroManager macroManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="unique")
    private QueryFilter uniqueResults;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        if (System.getProperty("moccacalendar.migrate.events") != null) {
            return EVENTS_STARTUP;
        }
        return EVENTS;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ApplicationReadyEvent) {
            this.addRecurrentPropertyToEvents(this.wikiManager.getCurrentWikiId());
        } else if (event instanceof WikiReadyEvent) {
            this.addRecurrentPropertyToEvents(((WikiReadyEvent)event).getWikiId());
        } else if (event instanceof DocumentDeletedEvent) {
            this.registerCalendarMacroAtNewLocation((XWikiDocument)source);
        } else if (event instanceof ExtensionEvent) {
            this.addRecurrentPropertyToEvents((ExtensionEvent)event);
        } else {
            this.logger.warn("ignored event [{}] which we listened for", (Object)event);
        }
    }

    private void registerCalendarMacroAtNewLocation(XWikiDocument oldMacroDoc) {
        try {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            DocumentReference oldMacroDocRef = oldMacroDoc.getDocumentReference();
            if (this.macroManager.hasWikiMacro(oldMacroDocRef)) {
                this.logger.debug("unregister moccacalendar macro in its old place");
                this.macroManager.unregisterWikiMacro(oldMacroDocRef);
            }
            DocumentReference newMacroDocRef = new DocumentReference("Macro", new SpaceReference(context.getWikiId(), new String[]{"MoccaCalendar", "Code"}));
            XWikiDocument newMacroDoc = context.getWiki().getDocument(newMacroDocRef, context);
            if (newMacroDoc.isNew()) {
                this.logger.warn("could not find moccacalendar macro in its new place");
            } else {
                WikiMacro macro = this.macroFactory.createWikiMacro(newMacroDocRef);
                this.logger.debug("found [{}] in [{}]", (Object)macro.getDescriptor().getId(), (Object)newMacroDocRef);
                this.macroManager.registerWikiMacro(newMacroDocRef, macro);
                this.logger.info("registered moccacalendar macro in its new place");
            }
        }
        catch (Exception xe) {
            this.logger.warn("could not register new moccacalendar macro automatically", (Throwable)xe);
        }
    }

    public long countAllEvents() throws QueryException {
        Query query = this.allEventsQuery();
        query.addFilter(this.uniqueResults).addFilter(this.countFilter);
        long result = (Long)query.execute().get(0);
        return result;
    }

    public long countMigratedEvents() throws QueryException {
        Query query = this.allMigratedEventsQuery();
        query.addFilter(this.uniqueResults).addFilter(this.countFilter);
        long result = (Long)query.execute().get(0);
        return result;
    }

    public int addRecurrentPropertyToEvents(int offset, int limit) throws QueryException, XWikiException {
        Query query = this.allEventsQuery();
        query.setOffset(offset).setLimit(limit);
        return this.addRecurrentPropertyToEvents(query, null, false);
    }

    private void addRecurrentPropertyToEvents(ExtensionEvent xie) {
        ExtensionId extensionId = xie.getExtensionId();
        String namespace = xie.getNamespace();
        if ("com.xwiki.mocca-calendar:application-mocca-calendar-ui".equals(extensionId.getId())) {
            if (namespace == null || "".equals(namespace)) {
                try {
                    for (String wikiId : this.wikiManager.getAllIds()) {
                        this.addRecurrentPropertyToEvents(wikiId);
                    }
                }
                catch (WikiManagerException e) {
                    this.logger.error("failed to migrate events", (Throwable)e);
                }
            } else if (namespace.startsWith("wiki:")) {
                String wikiId = namespace.substring(5);
                this.addRecurrentPropertyToEvents(wikiId);
            } else {
                this.logger.error("unknown installation namespace [{}]); skip migration step", (Object)namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecurrentPropertyToEvents(String wikiId) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentWikiId = xcontext.getWikiId();
        try {
            this.logger.info("migrate existing calendar events for wiki [{}]", (Object)wikiId);
            try {
                xcontext.setWikiId(wikiId);
                Query query = this.allEventsQuery();
                this.addRecurrentPropertyToEvents(query, wikiId, true);
            }
            finally {
                xcontext.setWikiId(currentWikiId);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while migrating calendar events in wiki [{}].", (Object)wikiId, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addRecurrentPropertyToEvents(Query eventQuery, String wikiIdOrNull, boolean logProgress) throws QueryException, XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String wikiId = wikiIdOrNull == null ? xcontext.getWikiId() : wikiIdOrNull;
        List results = eventQuery.execute();
        int step = Math.max(results.size() / 100 * 10, 10);
        int counter = 0;
        try {
            this.observationManager.notify((Event)new BeginMigrationEvent(), null);
            for (String docName : results) {
                this.addRecurrentPropertyToDocument(xcontext, docName);
                if (!logProgress || ++counter % step != 0) continue;
                this.logger.info("migrated {} events on wiki [{}]", (Object)counter, (Object)wikiId);
            }
            if (logProgress) {
                this.logger.info("migrated all events on wiki [{}]", (Object)wikiId);
            }
        }
        finally {
            this.observationManager.notify((Event)new FinishMigrationEvent(), null);
        }
        return counter;
    }

    private Query allEventsQuery() throws QueryException {
        Query query = this.queryManager.createQuery(String.format("from doc.object(%s) as event order by doc.creationDate", "MoccaCalendar.MoccaCalendarEventClass"), "xwql");
        return query;
    }

    private Query allMigratedEventsQuery() throws QueryException {
        Query query = this.queryManager.createQuery(String.format("from doc.object(%s) as event where not event.recurrent = -1 order by doc.creationDate", "MoccaCalendar.MoccaCalendarEventClass"), "xwql");
        return query;
    }

    private void addRecurrentPropertyToDocument(XWikiContext xcontext, String docName) throws XWikiException {
        XWikiDocument doc = xcontext.getWiki().getDocument(docName, xcontext);
        Vector events = doc.getObjects("MoccaCalendar.MoccaCalendarEventClass");
        boolean modified = false;
        for (BaseObject event : events) {
            boolean hasRecurrentProperty;
            boolean bl = hasRecurrentProperty = event.getPropertyList().contains("recurrent") && event.getField("recurrent") != null && !StringUtils.isEmpty((CharSequence)event.getStringValue("recurrent"));
            if (!hasRecurrentProperty) {
                IntegerProperty recurrent = new IntegerProperty();
                recurrent.setValue((Object)0);
                event.safeput("recurrent", (PropertyInterface)recurrent);
                modified = true;
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("added the property 'recurrent' to doc {}", (Object)docName);
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("doc {} already has a property 'recurrent' with prop {} and value [{}]", new Object[]{docName, event.getField("recurrent"), event.getStringValue("recurrent")});
        }
        if (modified) {
            xcontext.getWiki().saveDocument(doc, "add recurrent=false to event", true, xcontext);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("migrated event [{}]", (Object)doc.getPrefixedFullName());
            }
        }
    }

    private static class FinishMigrationEvent
    extends AbstractWikiEvent
    implements EndFoldEvent {
        private static final long serialVersionUID = 42L;

        private FinishMigrationEvent() {
        }
    }

    private static class BeginMigrationEvent
    extends AbstractWikiEvent
    implements BeginFoldEvent {
        private static final long serialVersionUID = 23L;

        private BeginMigrationEvent() {
        }
    }
}

