/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.meetings;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.EventInstance;
import org.xwiki.contrib.moccacalendar.EventSource;
import org.xwiki.contrib.moccacalendar.internal.Utils;
import org.xwiki.contrib.moccacalendar.internal.meetings.MeetingsSourceConfigurationClassInitializer;
import org.xwiki.contrib.moccacalendar.internal.utils.DefaultEventAssembly;
import org.xwiki.contrib.moccacalendar.internal.utils.EventQuery;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.QueryException;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="meetings")
@Singleton
@Component
public class MeetingEventSource
implements EventSource {
    private static final String MEETING_ENTRY_CLASS_NAME = "Meeting.Code.MeetingClass";
    private static final String MEETING_TEMPLATE_PAGE = "Meeting.Code.MeetingTemplate";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> stringDocRefResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private DefaultEventAssembly eventAssembly;
    @Inject
    private Logger logger;

    @Override
    public boolean isAvailable() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference meetingClassReference = new DocumentReference(xcontext.getWikiId(), Arrays.asList("Meeting", "Code"), "MeetingClass");
        this.logger.debug("check if [{}] exists in current wiki [{}]", this.compactWikiSerializer.serialize((EntityReference)meetingClassReference, new Object[0]), (Object)xcontext.getWikiId());
        try {
            return xcontext.getWiki().exists(meetingClassReference, xcontext);
        }
        catch (XWikiException e) {
            this.logger.error("There was an error while checking if [{}] exists in wiki [{}]. Root cause is: [{}]", new Object[]{this.compactWikiSerializer.serialize((EntityReference)meetingClassReference, new Object[0]), xcontext.getWikiId(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return false;
        }
    }

    @Override
    public LocalDocumentReference getConfigurationClass() {
        return MeetingsSourceConfigurationClassInitializer.classRef();
    }

    @Override
    public List<EventInstance> getEvents(Date dateFrom, Date dateTo, String filter, DocumentReference parentRef, boolean sortAscending) {
        ArrayList<EventInstance> events = new ArrayList<EventInstance>();
        try {
            this.logger.debug("try to determine source doc for events [{}]", (Object)parentRef);
            DocumentReference sourceDoc = parentRef;
            if (sourceDoc != null) {
                XWikiContext context = (XWikiContext)this.xcontextProvider.get();
                XWikiDocument configDoc = context.getWiki().getDocument(parentRef, context);
                BaseObject config = configDoc.getXObject(new DocumentReference(this.getConfigurationClass(), new WikiReference(context.getWikiId())));
                if (config != null) {
                    String sourceDocName = config.getStringValue("meetings");
                    this.logger.debug("we found source doc [{}] for calenderdoc [{}]", (Object)sourceDocName, (Object)parentRef);
                    sourceDoc = this.stringDocRefResolver.resolve((Object)sourceDocName, new Object[0]);
                } else {
                    this.logger.debug("no source doc for events in [{}]", (Object)parentRef);
                }
            } else {
                this.logger.debug("no source space for events");
            }
            EventQuery evQ = null;
            evQ = sourceDoc != null ? new EventQuery(MEETING_ENTRY_CLASS_NAME, MEETING_TEMPLATE_PAGE, sourceDoc.getWikiReference().getName()) : new EventQuery(MEETING_ENTRY_CLASS_NAME, MEETING_TEMPLATE_PAGE);
            evQ.addDateLimits(dateFrom, dateTo);
            if (!"wiki".equals(filter)) {
                evQ.addLocationFilter(filter, sourceDoc);
            }
            evQ.setAscending(sortAscending);
            List<DocumentReference> meetingDocRefs = this.eventAssembly.executeQuery(evQ);
            for (DocumentReference ref : meetingDocRefs) {
                EventInstance event = this.convertToEventInstance(evQ, ref);
                if (event == null) continue;
                events.add(event);
            }
        }
        catch (XWikiException | QueryException qe) {
            this.logger.error("unexpected query error while fetching meetings", qe);
        }
        return events;
    }

    private EventInstance convertToEventInstance(EventQuery evQ, DocumentReference meetingDocRef) {
        EventInstance event = null;
        try {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument eventDoc = context.getWiki().getDocument(meetingDocRef, context);
            BaseObject eventData = eventDoc.getXObject(this.stringDocRefResolver.resolve((Object)evQ.getClassName(), new Object[]{meetingDocRef}));
            if (eventData == null) {
                this.logger.error("data inconsistency: query returned [{}] which contains no object for [{}]", (Object)meetingDocRef, (Object)evQ.getClassName());
                return null;
            }
            event = new EventInstance();
            event.setEventDocRef(meetingDocRef);
            Date startDate = eventData.getDateValue(evQ.getStartDateName());
            DateTime startDateTime = new DateTime(startDate.getTime());
            event.setStartDate(startDateTime);
            Date endDate = Utils.fetchOrGuessEndDate(eventData, evQ.getStartDateName(), evQ.getEndDateName(), null);
            DateTime endDateTime = new DateTime(endDate.getTime());
            event.setEndDate(endDateTime);
            event.setEndDateExclusive(endDateTime);
            if (null == event.getTitle()) {
                event.setTitle(eventDoc.getRenderedTitle(Syntax.PLAIN_1_0, context));
            }
            if (null == event.getDescription()) {
                Utils.fillDescription(eventData, "description", context, event);
            }
        }
        catch (XWikiException e) {
            this.logger.warn("cannot find meeting event data [{}]", (Object)meetingDocRef, (Object)e);
        }
        return event;
    }

    @Override
    public EventInstance getEventInstance(Document eventDoc, Date eventStartDate) {
        EventQuery evQ = new EventQuery(MEETING_ENTRY_CLASS_NAME, MEETING_TEMPLATE_PAGE);
        return this.convertToEventInstance(evQ, eventDoc.getDocumentReference());
    }
}

