/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.importJob;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.importJob.ImportJobRequest;
import org.xwiki.contrib.moccacalendar.importJob.ImportJobStatus;
import org.xwiki.contrib.moccacalendar.internal.importJob.CalendarEventImporter;
import org.xwiki.fullcalendar.FullCalendarManager;
import org.xwiki.fullcalendar.model.CalendarEvent;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.stability.Unstable;

@Unstable
@Component
@Named(value="moccacalendar.import")
public class ImportJob
extends AbstractJob<ImportJobRequest, ImportJobStatus>
implements GroupedJob {
    public static final String JOB_TYPE = "moccacalendar.import";
    @Inject
    private Provider<XWikiContext> wikiContextProvider;
    @Inject
    private FullCalendarManager fullCalendarManager;
    @Inject
    private CalendarEventImporter calendarEventImporter;

    public String getType() {
        return JOB_TYPE;
    }

    public JobGroupPath getGroupPath() {
        ArrayList<String> path = new ArrayList<String>();
        path.add("moccacalendar");
        path.add("import");
        path.add(((ImportJobRequest)this.request).getParentRef());
        return new JobGroupPath(path);
    }

    protected ImportJobStatus createNewStatus(ImportJobRequest request) {
        return new ImportJobStatus(JOB_TYPE, request, this.observationManager, this.loggerManager);
    }

    protected void runInternal() {
        try {
            List calendarEventsJson = this.fullCalendarManager.getICalEventsFromFile(this.getICSFileContent(((ImportJobRequest)this.request).getFile()), null, null, true);
            ArrayList<XWikiDocument> eventDocuments = new ArrayList<XWikiDocument>();
            this.progressManager.pushLevelProgress(calendarEventsJson.size() + 1, (Object)this);
            for (CalendarEvent calendarEvent : calendarEventsJson) {
                this.progressManager.startStep((Object)this);
                if (((ImportJobStatus)this.status).isCanceled()) {
                    this.progressManager.endStep((Object)this);
                    break;
                }
                String eventName = calendarEvent.getTitle().trim();
                if (eventName.isEmpty()) continue;
                XWikiDocument eventDoc = this.calendarEventImporter.getUniqueEventName(eventName, ((ImportJobRequest)this.request).getParentRef(), eventDocuments);
                this.calendarEventImporter.importCalendarEvent(eventDoc, calendarEvent);
                eventDocuments.add(eventDoc);
                this.progressManager.endStep((Object)this);
                Thread.yield();
            }
            this.batchSave(eventDocuments);
        }
        catch (Exception e) {
            this.logger.warn("Import .ics file job failed. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new RuntimeException(e);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void batchSave(List<XWikiDocument> eventDocuments) throws XWikiException {
        if (!((ImportJobStatus)this.status).isCanceled()) {
            XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
            XWiki wiki = wikiContext.getWiki();
            this.progressManager.startStep((Object)this);
            for (XWikiDocument calendarEvent : eventDocuments) {
                wiki.saveDocument(calendarEvent, wikiContext);
            }
            this.progressManager.endStep((Object)this);
        }
    }

    private byte[] getICSFileContent(byte[] importedFileContent) {
        String importedFileString = new String(importedFileContent);
        int beginIndex = importedFileString.indexOf("BEGIN:VCALENDAR");
        int endIndex = importedFileString.indexOf("END:VCALENDAR") + "END:VCALENDAR".length();
        String filteredCalendarContent = importedFileString.substring(beginIndex, endIndex);
        return filteredCalendarContent.getBytes();
    }
}

