/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Date;
import org.xwiki.contrib.moccacalendar.EventInstance;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.stability.Unstable;

@Unstable
public final class Utils {
    private static final int EVENT_DURATION_MIN = 30;

    private Utils() {
    }

    public static Date fetchOrGuessEndDate(BaseObject eventData) {
        return Utils.fetchOrGuessEndDate(eventData, "startDate", "endDate", "allDay");
    }

    public static Date fetchOrGuessEndDate(BaseObject eventData, String startDateName, String endDateName, String allDayName) {
        Date endDate = eventData.getDateValue(endDateName);
        if (endDate == null) {
            boolean allDay = allDayName != null && eventData.getIntValue(allDayName) == 1;
            Date startDate = eventData.getDateValue(startDateName);
            endDate = Utils.guessEndDate(startDate, allDay);
        }
        return endDate;
    }

    public static Date guessEndDate(Date startDate, boolean allDay) {
        Date endDate = allDay ? new Date(startDate.getTime()) : new Date(startDate.getTime() + 1800000L);
        return endDate;
    }

    public static void fillDescription(BaseObject eventData, String descriptionPropertyName, XWikiContext context, EventInstance event) {
        XWikiDocument eventDoc = eventData.getOwnerDocument();
        String idString = eventDoc.getSyntax().toIdString();
        String description = eventData.getStringValue(descriptionPropertyName);
        event.setDescription(eventDoc.getRenderedContent(description, idString, Syntax.PLAIN_1_0.toIdString(), context));
        event.setDescriptionHtml(eventDoc.getRenderedContent(description, idString, Syntax.HTML_5_0.toIdString(), context));
    }
}

