/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Named(value="org.xwiki.contrib.moccacalendar.internal.CalendarEventParentChangeListener")
@Singleton
@Component
public class CalendarEventParentChangeListener
implements EventListener {
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceProvider refProvider;

    public String getName() {
        return this.getClass().getName();
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentUpdatedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument doc = (XWikiDocument)source;
        XWikiContext context = (XWikiContext)data;
        BaseObject eventData = doc.getXObject(doc.resolveClassReference("MoccaCalendar.MoccaCalendarEventClass"));
        if (eventData == null) {
            return;
        }
        DocumentReference parentReference = doc.getParentReference();
        try {
            XWikiDocument parentDoc = context.getWiki().getDocument(parentReference, context);
            if (parentDoc.isNew() || parentDoc.getXObjectSize(doc.resolveClassReference("MoccaCalendar.MoccaCalendarClass")) == 0) {
                this.logger.debug("target parent [{}] for [{}] is not a calendar; do not move", (Object)parentReference, (Object)doc);
                return;
            }
        }
        catch (XWikiException e) {
            this.logger.warn("could not determine if parent [{}] of document [{}] is a calandar", new Object[]{doc.getDocumentReference(), parentReference, e});
            return;
        }
        if (this.parentMatchesLocationParent(doc)) {
            this.logger.debug("calendar parent for event [{}] is ok - no move needed", (Object)doc.getDocumentReference());
            return;
        }
        try {
            DocumentReference targetReference = this.newDocumentLocation(doc, context);
            doc.rename(targetReference, context);
            this.logger.debug("renamed document [{}] to [{}]", (Object)doc.getOriginalDocument().getDocumentReference(), (Object)doc.getDocumentReference());
        }
        catch (XWikiException e) {
            this.logger.warn("could not move document [{}] to its new parent.", (Object)doc.getDocumentReference(), (Object)e);
        }
    }

    private boolean parentMatchesLocationParent(XWikiDocument doc) {
        DocumentReference docRef = doc.getDocumentReference();
        DocumentReference parentRef = doc.getParentReference();
        this.logger.trace("check document [{}] with parent ref [{}]", (Object)docRef, (Object)parentRef);
        SpaceReference parentLocation = parentRef.getLastSpaceReference();
        Object locationParent = docRef.getLastSpaceReference();
        String defaultPageName = this.refProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        if (defaultPageName.equals(docRef.getName())) {
            EntityReference locationParentParent = locationParent.getParent();
            locationParent = locationParentParent instanceof SpaceReference ? (SpaceReference)locationParentParent : null;
        }
        this.logger.trace("parent ref is [{}] while location parent is [{}]", (Object)parentLocation, locationParent);
        return parentLocation.equals(locationParent);
    }

    private DocumentReference newDocumentLocation(XWikiDocument eventDocument, XWikiContext context) throws XWikiException {
        DocumentReference docRef = eventDocument.getDocumentReference();
        DocumentReference parentRef = eventDocument.getParentReference();
        SpaceReference targetSpaceRef = parentRef.getLastSpaceReference();
        if (targetSpaceRef == null) {
            this.logger.warn("could not move event [{}] to calendar [{}], as this has no space", (Object)docRef, (Object)parentRef);
            return docRef;
        }
        DocumentReference targetReference = null;
        EntityReference defaultRef = this.refProvider.getDefaultReference(EntityType.DOCUMENT);
        targetReference = docRef.getName().equals(defaultRef.getName()) ? this.getDocumentWithUnusedSpace(docRef, targetSpaceRef, context) : this.getUnusedDocument(docRef, targetSpaceRef, context);
        this.logger.trace("new location for document [{}] is computed to [{}]", (Object)docRef, (Object)targetReference);
        return targetReference;
    }

    private DocumentReference getUnusedDocument(DocumentReference docRef, SpaceReference targetSpaceRef, XWikiContext context) throws XWikiException {
        String origDocName = docRef.getName();
        DocumentReference targetDocReference = new DocumentReference(origDocName, targetSpaceRef);
        while (context.getWiki().exists(targetDocReference, context)) {
            this.logger.trace("doc already exists [{}]; retry", (Object)targetDocReference);
            String docName = origDocName + "_" + String.valueOf(System.currentTimeMillis());
            targetDocReference = new DocumentReference(docName, targetSpaceRef);
        }
        return targetDocReference;
    }

    private DocumentReference getDocumentWithUnusedSpace(DocumentReference docRef, SpaceReference targetParentSpace, XWikiContext context) throws XWikiException {
        String origDocSpaceName = docRef.getLastSpaceReference().getName();
        SpaceReference targetDocSpace = new SpaceReference(origDocSpaceName, targetParentSpace);
        DocumentReference targetReference = new DocumentReference(docRef.getName(), targetDocSpace);
        while (context.getWiki().exists(targetReference, context)) {
            this.logger.trace("space already exists [{}]; retry", (Object)targetReference);
            String docSpaceName = origDocSpaceName + "_" + String.valueOf(System.currentTimeMillis());
            targetDocSpace = new SpaceReference(docSpaceName, targetParentSpace);
            targetReference = new DocumentReference(docRef.getName(), targetDocSpace);
        }
        return targetReference;
    }
}

