/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.metadata.confluencemigrator.script;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.resolvers.ConfluencePageTitleResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceResolverException;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceKeyResolver;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LoggerManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
@Named(value="metadatapro.metadataforconfluencemigration")
public class MetadataForConfluenceMigrationScriptService
implements ScriptService {
    private static final String SPACE_KEY_PATTERN = Pattern.quote("${spaceKey}");
    private static final String SET_NAME_PATTERN = Pattern.quote("${setName}");
    private static final TypeReference<List<String>> STRING_LIST_TYPE = new TypeReference<List<String>>(){};
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String SELECT = "select";
    private static final String CHECKBOX = "CHECKBOX";
    private static final String DROPDOWN = "DROPDOWN";
    private static final String DATE = "DATE";
    private static final String TEXT = "TEXT";
    private static final String MIGRATION_CLASS = "MetadataPro.MetadataForConfluenceMigrator.Code.MigrationClass";
    private static final LocalDocumentReference PACKAGES_STORE_REF = new LocalDocumentReference(List.of("MetadataPro", "MetadataForConfluenceMigrator", "Code"), "PackagesStore");
    private final SimpleDateFormat metadataForConfluenceDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private LoggerManager loggerManager;
    @Inject
    private ConfluencePageTitleResolver confluencePageResolver;
    @Inject
    private ConfluenceSpaceKeyResolver confluenceSpaceKeyResolver;
    @Inject
    private JobProgressManager progress;

    public void run(Document migrationDoc, String referenceTemplate, String titleTemplate) {
        Object obj = migrationDoc.getObject(MIGRATION_CLASS);
        if (obj == null) {
            this.logger.error("Please provide a migration document with a [{}] object", (java.lang.Object)MIGRATION_CLASS);
            return;
        }
        java.lang.Object pn = obj.getValue("package");
        if (pn instanceof String) {
            Document storeDoc;
            String packageName = (String)pn;
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            try {
                storeDoc = new Document(context.getWiki().getDocument((EntityReference)PACKAGES_STORE_REF, context), context);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to get the store document", (Throwable)e);
                return;
            }
            this.loggerManager.setLoggerLevel(this.logger.getName(), LogLevel.INFO);
            Attachment attachment = storeDoc.getAttachment(packageName);
            Stats s = new Stats();
            this.runMig(s, attachment, referenceTemplate, titleTemplate);
            try {
                byte[] stats = new ObjectMapper().writeValueAsString((java.lang.Object)s).getBytes(StandardCharsets.UTF_8);
                migrationDoc.addAttachment("stats.json", stats);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Failed to save the migration statistics", (Throwable)e);
            }
            obj.set("executed", (java.lang.Object)1);
            obj.set("titleTemplate", (java.lang.Object)titleTemplate);
            obj.set("referenceTemplate", (java.lang.Object)referenceTemplate);
            obj.set("spaces", List.copyOf(s.spaces));
            try {
                migrationDoc.save("Update migration status");
            }
            catch (XWikiException e) {
                this.logger.error("Failed to update the migration status", (Throwable)e);
            }
        } else {
            this.logger.error("package must be a string");
        }
    }

    private void runMig(Stats s, Attachment attachment, String referenceTemplate, String titleTemplate) {
        MetadataForConfluenceExport data;
        String json;
        try {
            json = attachment.getContentAsString();
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get the JSON attachment content", (Throwable)e);
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            data = (MetadataForConfluenceExport)objectMapper.readValue(json, MetadataForConfluenceExport.class);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse the JSON attachment content", (Throwable)e);
            return;
        }
        if (data.metadataFields == null || data.metadataFields.isEmpty()) {
            this.logger.error("Metadata fields are missing. We can't migrate this export.");
            return;
        }
        TreeMap<String, MetadataForConfluenceField> fields = new TreeMap<String, MetadataForConfluenceField>();
        for (MetadataForConfluenceField field : data.metadataFields) {
            fields.put(field.key, field);
        }
        this.progress.pushLevelProgress(2, (java.lang.Object)this);
        Map<String, Map<String, String>> importedSetsPerSpace = this.importMetadataSets(s, data.metadataSets, fields, referenceTemplate, titleTemplate);
        this.importMetadataValues(s, importedSetsPerSpace, data.metadataValues, fields);
        this.progress.popLevelProgress((java.lang.Object)this);
    }

    private void importMetadataValues(Stats s, Map<String, Map<String, String>> importedSetsPerSpace, List<MetadataForConfluenceValue> metadataValues, Map<String, MetadataForConfluenceField> fields) {
        int count = 0;
        for (MetadataForConfluenceValue value : metadataValues) {
            count += value.contentEntityObjects.size();
        }
        this.progress.pushLevelProgress(count, (java.lang.Object)this);
        for (MetadataForConfluenceValue value : metadataValues) {
            this.importContentEntityObjects(s, importedSetsPerSpace, fields, value);
        }
        this.progress.popLevelProgress((java.lang.Object)this);
    }

    private void importContentEntityObjects(Stats s, Map<String, Map<String, String>> importedSetsPerSpace, Map<String, MetadataForConfluenceField> fields, MetadataForConfluenceValue value) {
        for (MetadataForConfluenceContentEntityObject o : value.contentEntityObjects) {
            this.progress.startStep((java.lang.Object)this);
            s.spaces.add(o.spaceKey);
            Document valueDoc = this.getValueDoc(o);
            if (valueDoc == null) {
                ++s.failedValues;
            } else {
                String setRef;
                Map<String, String> sets = importedSetsPerSpace.get(value.metadataSetSpaceKey);
                String string = setRef = sets == null ? null : sets.get(value.metadataSetKey);
                if (setRef == null) {
                    this.logger.warn("Set [{}] in space [{}] could not be found. Skipping.", (java.lang.Object)value.metadataSetKey, (java.lang.Object)value.metadataSetSpaceKey);
                    ++s.failedValues;
                } else {
                    this.addValues(s, fields, o, valueDoc, setRef);
                    this.save(s, valueDoc);
                }
            }
            this.progress.endStep((java.lang.Object)this);
        }
    }

    private void addValues(Stats s, Map<String, MetadataForConfluenceField> fields, MetadataForConfluenceContentEntityObject o, Document valueDoc, String setRef) {
        this.logger.info("Setting values in [{}] for set [{}]", (java.lang.Object)valueDoc.getDocumentReference(), (java.lang.Object)setRef);
        Object object = valueDoc.getObject(setRef, true);
        for (Map.Entry<String, java.lang.Object> field : o.metadataFieldValues.entrySet()) {
            String fieldName = field.getKey();
            String xwikiFieldName = MetadataForConfluenceMigrationScriptService.getXWikiFieldName(fieldName);
            java.lang.Object val = field.getValue();
            if (val == null) continue;
            MetadataForConfluenceField fieldDescriptor = fields.get(field.getKey());
            if (fieldDescriptor == null) {
                this.logger.error("Failed to find field [{}] on [{}] for class [{}], value will be skipped", new java.lang.Object[]{field.getKey(), valueDoc.getDocumentReference(), setRef});
                ++s.failedValues;
                continue;
            }
            val = this.parseVal(field, val, fieldDescriptor, (EntityReference)valueDoc.getDocumentReference(), setRef);
            object.set(xwikiFieldName, val);
        }
    }

    private void save(Stats s, Document valueDoc) {
        try {
            valueDoc.save("Import values from Metadata for Confluence");
            ++s.importedValues;
        }
        catch (XWikiException e) {
            this.logger.error("Failed to save document [{}], values won't be imported", (java.lang.Object)valueDoc.getDocumentReference());
            ++s.failedValues;
        }
    }

    private Document getValueDoc(MetadataForConfluenceContentEntityObject o) {
        Document valueDoc;
        EntityReference valueDocRef;
        try {
            valueDocRef = this.confluencePageResolver.getDocumentByTitle(o.spaceKey, o.title);
            if (valueDocRef == null) {
                this.logger.warn("Failed to find Confluence document with spaceKey [{}]  and title [{}], values for this page will not be imported", (java.lang.Object)o.spaceKey, (java.lang.Object)o.title);
                return null;
            }
        }
        catch (ConfluenceResolverException e) {
            this.logger.error("Failed to resolve Confluence page space=[{}] title=[{}], values for this page won't be imported", new java.lang.Object[]{o.spaceKey, o.title, e});
            return null;
        }
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki wiki = new XWiki(context.getWiki(), context);
        try {
            valueDoc = wiki.getDocument(valueDocRef);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get the migrated Confluence document [{}], values for this document won't be imported", (java.lang.Object)valueDocRef, (java.lang.Object)e);
            return null;
        }
        return valueDoc;
    }

    private java.lang.Object parseVal(Map.Entry<String, java.lang.Object> field, java.lang.Object val, MetadataForConfluenceField fieldDescriptor, EntityReference valueDocRef, String setRef) {
        try {
            switch (fieldDescriptor.typeName) {
                case "CHECKBOX": {
                    return new ObjectMapper().readValue((String)val, STRING_LIST_TYPE);
                }
                case "DROPDOWN": {
                    List v = (List)new ObjectMapper().readValue((String)val, STRING_LIST_TYPE);
                    if (v.size() > 1) {
                        return v;
                    }
                    return v.get(0);
                }
                case "DATE": {
                    return this.metadataForConfluenceDateFormat.parse(StringUtils.removeEnd((String)((String)val).trim(), (String)"+").trim());
                }
                case "TEXT": {
                    return this.escapeXWiki21((String)val);
                }
            }
            this.logger.warn("Unhandled field type [{}], the imported value might be wrong", (java.lang.Object)fieldDescriptor.typeName);
            return val;
        }
        catch (JsonProcessingException | ParseException e) {
            this.logger.error("Could not parse value [{}] for field [{}] in [{}], set [{}], the stored value might be wrong", new java.lang.Object[]{val, field.getKey(), valueDocRef, setRef});
            return val;
        }
    }

    private String escapeXWiki21(String content) {
        char[] result = new char[content.length() * 2];
        for (int i = 0; i < content.length(); ++i) {
            result[2 * i] = 126;
            result[2 * i + 1] = content.charAt(i);
        }
        return String.valueOf(result);
    }

    private Map<String, Map<String, String>> importMetadataSets(Stats s, List<MetadataForConfluenceSet> metadataSets, Map<String, MetadataForConfluenceField> fields, String referenceTemplate, String titleTemplate) {
        HashMap<String, Map<String, String>> importedSetsPerSpace = new HashMap<String, Map<String, String>>(fields.size());
        this.progress.pushLevelProgress(metadataSets.size(), (java.lang.Object)this);
        for (MetadataForConfluenceSet set : metadataSets) {
            this.progress.startStep((java.lang.Object)this);
            this.importMetadataSet(s, importedSetsPerSpace, set, fields, referenceTemplate, titleTemplate);
            this.progress.endStep((java.lang.Object)this);
        }
        this.progress.popLevelProgress((java.lang.Object)this);
        return importedSetsPerSpace;
    }

    private void importMetadataSet(Stats s, Map<String, Map<String, String>> importedSetsPerSpace, MetadataForConfluenceSet set, Map<String, MetadataForConfluenceField> fields, String referenceTemplate, String titleTemplate) {
        DocumentReference setReference;
        Document setDoc;
        java.lang.Object setReferenceString = this.applyTemplate(referenceTemplate, set);
        if (StringUtils.isEmpty((CharSequence)setReferenceString)) {
            setReferenceString = "MetadataPro.Sets." + MetadataForConfluenceMigrationScriptService.getSetName(set);
        }
        if ((setDoc = this.getSetDocument(s, set, titleTemplate, setReference = this.resolver.resolve(setReferenceString, new java.lang.Object[0]))) == null) {
            return;
        }
        BaseClass baseClass = setDoc.getxWikiClass().getXWikiClass();
        TreeMap defaultValues = new TreeMap();
        TreeSet<String> requiredFields = new TreeSet<String>();
        long importedFields = 0L;
        for (MetadataForConfluenceFieldConfiguration fieldConf : set.metadataFields) {
            List<?> d;
            MetadataForConfluenceField field = fields.get(fieldConf.key);
            if (field == null) {
                this.logger.warn("Could not find field [{}] when importing set [{}]. Skipping.", (java.lang.Object)fieldConf.key, (java.lang.Object)set.key);
                ++s.skippedFields;
                continue;
            }
            String xwikiFieldName = MetadataForConfluenceMigrationScriptService.getXWikiFieldName(fieldConf.key);
            if (this.addField(s, baseClass, xwikiFieldName, field, fieldConf)) {
                this.logger.info("Imported field [{}] to [{}] as [{}]", new java.lang.Object[]{fieldConf.key, setReference, xwikiFieldName});
                ++importedFields;
            } else {
                this.logger.warn("Field [{}] in [{}] as [{}] already exists, it will be updated", new java.lang.Object[]{fieldConf.key, setReference, xwikiFieldName});
                ++s.skippedFields;
            }
            if (fieldConf.required) {
                requiredFields.add(xwikiFieldName);
            }
            if ((d = MetadataForConfluenceMigrationScriptService.getDefaultValues(fieldConf.defaultValue)) == null || d.isEmpty()) continue;
            defaultValues.put(xwikiFieldName, d);
        }
        Map sets = importedSetsPerSpace.computeIfAbsent(set.spaceKey, k -> new HashMap());
        sets.put(set.key, setReferenceString);
        this.saveSet(s, set, setDoc, setReference, requiredFields, defaultValues, importedFields);
    }

    private Document getSetDocument(Stats s, MetadataForConfluenceSet set, String titleTemplate, DocumentReference setReference) {
        Document setDoc;
        String title = this.applyTemplate(titleTemplate, set);
        if (StringUtils.isEmpty((CharSequence)title)) {
            title = MetadataForConfluenceMigrationScriptService.getSetName(set);
        }
        this.logger.info("Importing set [{}] to [{}] with title [{}]", new java.lang.Object[]{set.key, setReference, title});
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            setDoc = new Document(context.getWiki().getDocument(setReference, context), context);
            setDoc.setTitle(title);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get the document for storing the set [{}]. Skipping.", (java.lang.Object)setReference, (java.lang.Object)e);
            ++s.failedSets;
            return null;
        }
        if (!setDoc.isNew()) {
            this.logger.warn("Set [{}] already exists, it will be updated", (java.lang.Object)setReference);
        }
        return setDoc;
    }

    private void saveSet(Stats s, MetadataForConfluenceSet set, Document setDoc, DocumentReference setReference, Collection<String> requiredFields, Map<String, List<?>> defaultValues, long importedFields) {
        Object object = setDoc.getObject("MetadataPro.Code.MetadataSetClass", true);
        EntityReference space = null;
        try {
            space = this.confluenceSpaceKeyResolver.getSpaceByKey(set.spaceKey);
        }
        catch (ConfluenceResolverException e) {
            this.logger.error("Failed to resolve space [{}]", (java.lang.Object)set.spaceKey, (java.lang.Object)e);
        }
        if (space == null) {
            this.logger.warn("Failed to resolve space [{}], set [{}] will not be restricted to this space", (java.lang.Object)set.spaceKey, (java.lang.Object)setReference);
        } else {
            object.set("includedSpaces", List.of((String)this.serializer.serialize(space, new java.lang.Object[0])));
        }
        object.set("requiredFields", List.copyOf(requiredFields));
        try {
            object.set("defaultValues", (java.lang.Object)new ObjectMapper().writeValueAsString(defaultValues));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to write the default values. Fields won't have default values.");
        }
        try {
            setDoc.save("Import set from Metadata for Confluence");
            ++s.importedSets;
            s.importedFields += importedFields;
        }
        catch (XWikiException e) {
            this.logger.error("Failed to save set [{}]. Skipping.", (java.lang.Object)setReference);
            ++s.failedSets;
            s.skippedFields += importedFields;
        }
    }

    private static String getXWikiFieldName(String fieldName) {
        return StringUtils.removeStart((String)fieldName, (String)"metadatafield.");
    }

    private boolean addField(Stats s, BaseClass baseClass, String fieldName, MetadataForConfluenceField field, MetadataForConfluenceFieldConfiguration fieldConf) {
        switch (field.typeName) {
            case "CHECKBOX": {
                return this.addStaticListField(baseClass, fieldName, field, fieldConf, CHECKBOX, true);
            }
            case "DROPDOWN": {
                return this.addStaticListField(baseClass, fieldName, field, fieldConf, SELECT, false);
            }
            case "DATE": {
                return baseClass.addDateField(fieldName, field.title, YYYY_MM_DD, 0);
            }
            case "TEXT": {
                return baseClass.addTextAreaField(fieldName, field.title, 80, 15, TextAreaClass.EditorType.WYSIWYG, TextAreaClass.ContentType.WIKI_TEXT);
            }
        }
        if (baseClass.addTextField(fieldName, field.title, 20)) {
            this.logger.warn("Unhandled field type [{}], falling back to small string", (java.lang.Object)field.typeName);
            ++s.unknownTypeFields;
            return true;
        }
        return false;
    }

    private static List<?> getDefaultValues(java.lang.Object d) {
        if (d == null) {
            return null;
        }
        if (d instanceof String) {
            try {
                return (List)new ObjectMapper().readValue((String)d, STRING_LIST_TYPE);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return List.of(d);
    }

    private boolean addStaticListField(BaseClass baseClass, String fieldName, MetadataForConfluenceField field, MetadataForConfluenceFieldConfiguration fieldConf, String displayType, boolean multiSelect) {
        java.lang.Object firstDefVal;
        List<String> values;
        List<?> defValue = MetadataForConfluenceMigrationScriptService.getDefaultValues(fieldConf.defaultValue);
        try {
            values = (List<String>)new ObjectMapper().readValue(field.typeConfiguration, STRING_LIST_TYPE);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse list of values for field [{}]. Skipping.", (java.lang.Object)fieldConf.key);
            values = List.of();
        }
        String sep = this.findSep(values);
        String vals = String.join((CharSequence)sep, values);
        String first = null;
        java.lang.Object object = firstDefVal = defValue == null || defValue.isEmpty() ? null : (java.lang.Object)defValue.get(0);
        if (firstDefVal != null) {
            first = firstDefVal instanceof String ? (String)firstDefVal : firstDefVal.toString();
        }
        return baseClass.addStaticListField(fieldName, field.title, SELECT.equals(displayType) ? 1 : 20, multiSelect, false, vals, displayType, sep, first);
    }

    private String findSep(List<String> values) {
        return this.findSep(values, "|;,/^:&+ ", 0);
    }

    private String findSep(List<String> values, String candidateSeparators, int i) {
        if (i >= candidateSeparators.length()) {
            return this.findSepPlus(values, "++");
        }
        char candidateSeparator = candidateSeparators.charAt(i);
        for (String v : values) {
            if (!StringUtils.isNotEmpty((CharSequence)v) || v.indexOf(candidateSeparator) == -1) continue;
            return this.findSep(values, candidateSeparators, i + 1);
        }
        return String.valueOf(candidateSeparator);
    }

    private String findSepPlus(List<String> values, String candidateSeparator) {
        for (String v : values) {
            if (!StringUtils.isNotEmpty((CharSequence)v) || !v.contains(candidateSeparator)) continue;
            return this.findSepPlus(values, candidateSeparator + "+");
        }
        return candidateSeparator;
    }

    private String applyTemplate(String template, MetadataForConfluenceSet set) {
        if (StringUtils.isEmpty((CharSequence)template)) {
            return null;
        }
        String setName = MetadataForConfluenceMigrationScriptService.getSetName(set);
        return template.replaceAll(SPACE_KEY_PATTERN, set.spaceKey).replaceAll(SET_NAME_PATTERN, setName);
    }

    private static String getSetName(MetadataForConfluenceSet set) {
        return StringUtils.removeStart((String)set.key, (String)"metadataset.").replace('.', '_');
    }

    private static final class Stats {
        public long importedValues;
        public long importedSets;
        public long importedFields;
        public long failedValues;
        public long failedSets;
        public long skippedFields;
        public long unknownTypeFields;
        private final Collection<String> spaces = new TreeSet<String>();

        Stats() {
        }
    }

    private static final class MetadataForConfluenceExport {
        public List<MetadataForConfluenceField> metadataFields;
        public List<MetadataForConfluenceSet> metadataSets;
        public List<MetadataForConfluenceValue> metadataValues;

        private MetadataForConfluenceExport() {
        }
    }

    private static final class MetadataForConfluenceValue {
        public String metadataSetKey;
        public String metadataSetSpaceKey;
        public List<MetadataForConfluenceContentEntityObject> contentEntityObjects;

        private MetadataForConfluenceValue() {
        }
    }

    private static final class MetadataForConfluenceContentEntityObject {
        public String spaceKey;
        public String title;
        public boolean blogPost;
        public long blogPostPostingTimestamp;
        public Map<String, java.lang.Object> metadataFieldValues;

        private MetadataForConfluenceContentEntityObject() {
        }
    }

    private static final class MetadataForConfluenceSet {
        public String key;
        public String description;
        public String spaceKey;
        public String title;
        public List<MetadataForConfluenceFieldConfiguration> metadataFields;

        private MetadataForConfluenceSet() {
        }
    }

    private static final class MetadataForConfluenceFieldConfiguration {
        public String key;
        public boolean hidden;
        public boolean required;
        public java.lang.Object defaultValue;

        private MetadataForConfluenceFieldConfiguration() {
        }
    }

    private static final class MetadataForConfluenceField {
        public String key;
        public String description;
        public String spaceKey;
        public String title;
        public String typeName;
        public String typeConfiguration;

        private MetadataForConfluenceField() {
        }
    }
}

