/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.meeting.test.ui.po;

import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.SuggestInputElement;

public class MeetingEntryInlinePage
extends InlinePage {
    public static final String VALUE_ATTRIBUTE_NAME = "Value";
    @FindBy(id="Meeting.Code.MeetingClass_0_startDate")
    private WebElement startDateInput;
    @FindBy(id="Meeting.Code.MeetingClass_0_endDate")
    private WebElement endDateInput;
    @FindBy(id="Meeting.Code.MeetingClass_0_place")
    private WebElement placeInput;
    @FindBy(id="Meeting.Code.MeetingClass_0_description")
    private WebElement descriptionInput;
    @FindBy(id="content")
    private WebElement notesInput;
    @FindBy(id="Meeting.Code.MeetingClass_0_status")
    private WebElement statusInput;
    @FindBy(id="Meeting.Code.MeetingClass_0_leader")
    private WebElement leaderInput;
    @FindBy(id="Meeting.Code.MeetingClass_0_participants")
    private WebElement participantsInput;

    public String getStartDate() {
        return this.startDateInput.getAttribute(VALUE_ATTRIBUTE_NAME);
    }

    public void setStartDate(String startDate) {
        this.startDateInput.clear();
        this.startDateInput.sendKeys(new CharSequence[]{startDate});
    }

    public String getEndDate() {
        return this.endDateInput.getAttribute(VALUE_ATTRIBUTE_NAME);
    }

    public void setEndDate(String endDate) {
        this.endDateInput.clear();
        this.endDateInput.sendKeys(new CharSequence[]{endDate});
    }

    public String getPlace() {
        return this.placeInput.getAttribute(VALUE_ATTRIBUTE_NAME);
    }

    public void setPlace(String place) {
        this.placeInput.clear();
        this.placeInput.sendKeys(new CharSequence[]{place});
    }

    public String getDescription() {
        return this.placeInput.getAttribute(VALUE_ATTRIBUTE_NAME);
    }

    public void setDescription(String description) {
        this.descriptionInput.clear();
        this.descriptionInput.sendKeys(new CharSequence[]{description});
    }

    public String getNotes() {
        return this.notesInput.getAttribute(VALUE_ATTRIBUTE_NAME);
    }

    public void setNotes(String notes) {
        this.notesInput.clear();
        this.notesInput.sendKeys(new CharSequence[]{notes});
    }

    public String getStatus() {
        Select notesSelect = new Select(this.notesInput);
        return notesSelect.getFirstSelectedOption().getText();
    }

    public void setStatus(String status) {
        Select statusSelect = new Select(this.statusInput);
        statusSelect.selectByVisibleText(status);
    }

    public void setLeader(String leader) {
        new SuggestInputElement(this.leaderInput).clearSelectedSuggestions().sendKeys(new CharSequence[]{leader}).waitForSuggestions().selectByVisibleText(leader).hideSuggestions();
    }

    public void setParticipants(List<String> participants) {
        SuggestInputElement participantsSuggestInput = new SuggestInputElement(this.participantsInput);
        participantsSuggestInput.clearSelectedSuggestions();
        for (String participant : participants) {
            participantsSuggestInput.sendKeys(new CharSequence[]{participant}).waitForSuggestions().selectByVisibleText(participant);
        }
        participantsSuggestInput.hideSuggestions();
    }
}

