/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.script;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.Licensor;
import com.xwiki.licensing.internal.UserCounter;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.extension.ExtensionId;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.properties.converter.Converter;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.sheet.SheetManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="licensing.licensor")
@Singleton
public class LicensorScriptService
implements ScriptService,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private Licensor licensor;
    @Inject
    private LicenseManager licenseManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private EntityReferenceProvider entityReferenceProvider;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64decoder;
    @Inject
    private Converter<License> converter;
    @Inject
    private UserCounter userCounter;
    @Inject
    private SheetManager sheetManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;

    public void initialize() throws InitializationException {
        if (!LicensingUtils.isPristineImpl(this.licensor)) {
            throw new InitializationException("Integrity check failed while loading the licensor.");
        }
    }

    public License getLicense() {
        return this.licensor.getLicense();
    }

    public License getLicenseForExtension(ExtensionId extensionId) {
        return this.licensor.getLicense(extensionId);
    }

    public License getLicenseForEntity(EntityReference reference) {
        return this.licensor.getLicense(reference);
    }

    public boolean hasLicensure() {
        return this.licensor.hasLicensure();
    }

    public boolean hasLicensureForExtension(ExtensionId extensionId) {
        return this.licensor.hasLicensure(extensionId);
    }

    @Unstable
    public boolean isLicenseExpiring(ExtensionId extensionId) {
        return this.licensor.isLicenseExpiring(extensionId);
    }

    public boolean hasLicensureForEntity(EntityReference reference) {
        return this.licensor.hasLicensure(reference);
    }

    public Licensor getLicensor() {
        return this.licensor;
    }

    public LicenseManager getLicenseManager() {
        if (this.contextualAuthorizationManager.hasAccess(Right.PROGRAM)) {
            return this.licenseManager;
        }
        return null;
    }

    public LicensedExtensionManager getLicensedExtensionManager() {
        if (this.contextualAuthorizationManager.hasAccess(Right.PROGRAM)) {
            return this.licensedExtensionManager;
        }
        return null;
    }

    public boolean addLicense(String license) throws AccessDeniedException, IOException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN, this.entityReferenceProvider.getDefaultReference(EntityType.WIKI));
        return this.licenseManager.add((License)this.converter.convert(License.class, (Object)this.base64decoder.decode(license)));
    }

    public boolean addLicense(byte[] license) throws AccessDeniedException, IOException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN, this.entityReferenceProvider.getDefaultReference(EntityType.WIKI));
        return this.licenseManager.add((License)this.converter.convert(License.class, (Object)license));
    }

    public void checkLicense() {
        if (!this.licensor.hasLicensure()) {
            // empty if block
        }
    }

    @Unstable
    public Long getUserCount() {
        try {
            return this.userCounter.getUserCount();
        }
        catch (Exception e) {
            this.logger.warn("Failed to count the users. Root cause is: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public List<DocumentReference> getUnlicensedSheets(DocumentReference documentReference, String action) {
        try {
            DocumentModelBridge documentModelBridge = this.documentAccessBridge.getDocument(documentReference);
            List sheetsUsedByDocument = this.sheetManager.getSheets(documentModelBridge, action);
            return sheetsUsedByDocument.stream().filter(sheet -> !this.hasLicensureForEntity((EntityReference)sheet)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error("Failed to get the list of associated sheets. Root cause is: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }
}

