/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.upgrades.notifications;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.internal.upgrades.notifications.ExtensionAutoUpgradedEvent;
import com.xwiki.licensing.internal.upgrades.notifications.ExtensionAutoUpgradedFailedEvent;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationDisplayer;
import org.xwiki.rendering.block.Block;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="ExtensionAutoUpgradedEventDisplayer")
public class ExtensionAutoUpgradedEventDisplayer
implements NotificationDisplayer {
    protected static final String NAME = "ExtensionAutoUpgradedEventDisplayer";
    protected static final List<String> EVENTS = Arrays.asList(ExtensionAutoUpgradedEvent.class.getCanonicalName(), ExtensionAutoUpgradedFailedEvent.class.getCanonicalName());
    protected static final LocalDocumentReference LICENSOR_DOC = new LocalDocumentReference("Licenses", "WebHome");
    protected static final String EVENT_BINDING_NAME = "event";
    @Inject
    private TemplateManager templateManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private Logger logger;

    public Block renderNotification(CompositeEvent eventNotification) throws NotificationException {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
        Template customTemplate = this.templateManager.getTemplate("extensionAutoUpgraded/extensionAutoUpgraded.vm");
        try {
            xcontext.setDoc(xcontext.getWiki().getDocument((EntityReference)LICENSOR_DOC, xcontext));
            scriptContext.setAttribute(EVENT_BINDING_NAME, eventNotification, 100);
            return this.templateManager.execute(customTemplate);
        }
        catch (Exception e) {
            this.logger.warn("Failed to render custom template. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public List<String> getSupportedEvents() {
        return EVENTS;
    }
}

