/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.upgrades;

import com.xwiki.licensing.internal.upgrades.notifications.ExtensionAutoUpgradedEvent;
import com.xwiki.licensing.internal.upgrades.notifications.ExtensionAutoUpgradedFailedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component(roles={UpgradeExtensionHandler.class})
@Singleton
public class UpgradeExtensionHandler {
    protected static final String LICENSOR_API_ID = "com.xwiki.licensing:application-licensing-licensor-api";
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected JobExecutor jobExecutor;
    @Inject
    private Logger logger;
    @Inject
    private ExtensionRepositoryManager extensionRepositoryManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private ContextualLocalizationManager localization;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public void tryUpgradeExtensionToLastVersion(InstalledExtension installedExtension, String namespace) {
        ExtensionId installedExtensionId = installedExtension.getId();
        List<Version> versions = this.getInstallableVersions(installedExtensionId);
        for (Version version : versions) {
            ExtensionId toInstallExtensionId = new ExtensionId(installedExtensionId.getId(), version);
            try {
                this.installExtension(toInstallExtensionId, namespace);
                String doneUpgradeMessage = this.localization.getTranslationPlain("licensor.notification.autoUpgrade.done", new Object[]{installedExtension.getName(), installedExtensionId.getVersion().getValue(), toInstallExtensionId.getVersion().getValue()});
                this.observationManager.notify((Event)new ExtensionAutoUpgradedEvent(), (Object)LICENSOR_API_ID, (Object)doneUpgradeMessage);
                break;
            }
            catch (InterruptedException | JobException e) {
                String failedUpgradeMessage = this.localization.getTranslationPlain("licensor.notification.autoUpgrade.failed", new Object[]{installedExtension.getName(), installedExtensionId.getVersion().getValue(), toInstallExtensionId.getVersion().getValue()});
                this.observationManager.notify((Event)new ExtensionAutoUpgradedFailedEvent(), (Object)LICENSOR_API_ID, (Object)failedUpgradeMessage);
            }
        }
    }

    protected Job installExtension(ExtensionId extensionId, String namespace) throws JobException, InterruptedException {
        InstallRequest installRequest = this.getInstallRequest(extensionId, namespace);
        Job job = this.jobExecutor.execute("install", (Request)installRequest);
        job.join();
        return job;
    }

    protected InstallRequest getInstallRequest(ExtensionId extensionId, String namespace) {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(ExtensionRequest.getJobId((String)"action", (String)extensionId.getId(), (String)namespace));
        installRequest.addExtension(extensionId);
        installRequest.addNamespace(namespace);
        installRequest.setRootModificationsAllowed(true);
        installRequest.setInteractive(false);
        installRequest.setProperty("user.reference", (Object)this.documentAccessBridge.getCurrentUserReference());
        installRequest.setExtensionProperty("user.reference", this.serializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]));
        return installRequest;
    }

    public List<Version> getInstallableVersions(ExtensionId extensionId) {
        ArrayList<Version> versions = new ArrayList<Version>();
        try {
            IterableResult iterableVersions = this.extensionRepositoryManager.resolveVersions(extensionId.getId(), 0, -1);
            for (Version version : iterableVersions) {
                if (extensionId.getVersion().compareTo((Object)version) >= 0 || version.getType() != Version.Type.STABLE) continue;
                versions.add(version);
            }
            Collections.reverse(versions);
        }
        catch (ResolveException e) {
            this.logger.warn("Failed to resolve versions of extension [{}]. Root cause is [{}]", (Object)extensionId.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return versions;
    }
}

