/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.upgrades;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component(roles={NewVersionNotificationManager.class})
@Singleton
public class NewVersionNotificationManager {
    protected static final String EXTENSION_ID = "extensionId";
    protected static final String NAMESPACE = "namespace";
    protected static final String VERSION = "version";
    protected static final List<String> CODE_SPACE = Arrays.asList("Licenses", "Code");
    protected static final LocalDocumentReference LICENSING_CONFIG_DOC = new LocalDocumentReference(CODE_SPACE, "LicensingConfig");
    protected static final LocalDocumentReference NEW_VERSION_NOTIFICATION_CLASS = new LocalDocumentReference(CODE_SPACE, "NewVersionNotificationClass");
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public boolean isNotificationAlreadySent(String extensionId, String namespaceName, String version) {
        try {
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            List versionNotifObjects = xcontext.getWiki().getDocument((EntityReference)LICENSING_CONFIG_DOC, xcontext).getXObjects((EntityReference)NEW_VERSION_NOTIFICATION_CLASS);
            return versionNotifObjects != null && versionNotifObjects.stream().filter(obj -> obj != null && this.objectHasValue((BaseObject)obj, EXTENSION_ID, extensionId) && this.objectHasValue((BaseObject)obj, NAMESPACE, namespaceName) && this.objectHasValue((BaseObject)obj, VERSION, version)).count() > 0L;
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to check if a NewVersionNotification was already sent for [{}]. Root cause is: [{}]", (Object)extensionId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }

    public void markNotificationAsSent(String extensionId, String namespaceName, String version) {
        try {
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            XWikiDocument configDoc = xcontext.getWiki().getDocument((EntityReference)LICENSING_CONFIG_DOC, xcontext).clone();
            List versionNotifObjects = configDoc.getXObjects((EntityReference)NEW_VERSION_NOTIFICATION_CLASS);
            boolean notificationObjectExists = false;
            if (versionNotifObjects != null) {
                notificationObjectExists = this.updateExistingNotification(versionNotifObjects, extensionId, namespaceName, version);
            }
            if (!notificationObjectExists) {
                int id = configDoc.createXObject((EntityReference)NEW_VERSION_NOTIFICATION_CLASS, xcontext);
                BaseObject obj = configDoc.getXObject((EntityReference)NEW_VERSION_NOTIFICATION_CLASS, id);
                obj.setStringValue(EXTENSION_ID, extensionId);
                obj.setStringValue(NAMESPACE, namespaceName);
                obj.setStringValue(VERSION, version);
            }
            xcontext.getWiki().saveDocument(configDoc, String.format("Added NewVersionNotificationClass object for %s.", extensionId), xcontext);
        }
        catch (XWikiException e) {
            this.logger.warn("Failed add NewVersionNotificationClass object for [{}]. Root cause is: [{}]", (Object)extensionId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private boolean updateExistingNotification(List<BaseObject> versionNotifObjects, String extensionId, String namespaceName, String version) {
        boolean notificationObjectExists = false;
        for (BaseObject obj : versionNotifObjects) {
            if (obj == null || !this.objectHasValue(obj, EXTENSION_ID, extensionId) || !this.objectHasValue(obj, NAMESPACE, namespaceName)) continue;
            if (!this.objectHasValue(obj, VERSION, version)) {
                obj.setStringValue(VERSION, version);
            }
            notificationObjectExists = true;
        }
        return notificationObjectExists;
    }

    private boolean objectHasValue(BaseObject obj, String name, String value) {
        return Objects.equals(obj.getStringValue(name), value);
    }
}

