/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.upgrades;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensingConfiguration;
import com.xwiki.licensing.internal.upgrades.NewVersionNotificationManager;
import com.xwiki.licensing.internal.upgrades.UpgradeExtensionHandler;
import com.xwiki.licensing.internal.upgrades.notifications.newVersion.NewExtensionVersionAvailableEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component(roles={NewExtensionVersionAvailableManager.class})
@Singleton
public class NewExtensionVersionAvailableManager {
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private UpgradeExtensionHandler upgradeExtensionHandler;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private LicensingConfiguration licensingConfig;
    @Inject
    private Logger logger;
    @Inject
    private NewVersionNotificationManager newVersionNotificationManager;

    public void checkLicensedExtensionsAvailableVersions() {
        List<String> allowlist = this.licensingConfig.getAutoUpgradeAllowList();
        for (ExtensionId extensionId : this.licensedExtensionManager.getLicensedExtensions()) {
            if (allowlist.contains(extensionId.getId())) continue;
            InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(extensionId);
            Collection namespaces = installedExtension.getNamespaces();
            if (namespaces == null) {
                this.notifyExtensionVersionAvailable(installedExtension.getId(), null);
                continue;
            }
            for (String namespace : installedExtension.getNamespaces()) {
                this.notifyExtensionVersionAvailable(installedExtension.getId(), namespace);
            }
        }
    }

    private void notifyExtensionVersionAvailable(ExtensionId extensionId, String namespace) {
        InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(extensionId.getId(), namespace);
        List<Version> installableVersions = this.upgradeExtensionHandler.getInstallableVersions(installedExtension.getId());
        if (installableVersions.isEmpty()) {
            return;
        }
        try {
            String namespaceName;
            String string = namespaceName = namespace != null ? namespace : "root";
            if (!this.newVersionNotificationManager.isNotificationAlreadySent(extensionId.getId(), namespaceName, installableVersions.get(0).getValue())) {
                HashMap<String, String> extensionInfo = new HashMap<String, String>();
                extensionInfo.put("extensionName", installedExtension.getName());
                extensionInfo.put("namespace", namespaceName);
                extensionInfo.put("version", installableVersions.get(0).getValue());
                this.observationManager.notify((Event)new NewExtensionVersionAvailableEvent(new ExtensionId(extensionId.getId(), installableVersions.get(0)), namespace), (Object)extensionId.getId(), (Object)new ObjectMapper().writeValueAsString(extensionInfo));
                this.newVersionNotificationManager.markNotificationAsSent(extensionId.getId(), namespaceName, installableVersions.get(0).getValue());
            }
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed to send a NewExtensionVersionAvailableEvent for [{}]. Root cause is [{}]", (Object)extensionId.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

