/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.upgrades;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.repository.internal.installed.DefaultInstalledExtension;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="LicensingSchedulerListener")
@Singleton
public class LicensingSchedulerListener
extends AbstractEventListener
implements Initializable {
    public static final String ROLE_HINT = "LicensingSchedulerListener";
    protected static final String LICENSOR_API_ID = "com.xwiki.licensing:application-licensing-licensor-api";
    protected static final List<String> CODE_SPACE = Arrays.asList("Licenses", "Code");
    protected static final LocalDocumentReference EXTENSION_UPGRADE_JOB_DOC = new LocalDocumentReference(CODE_SPACE, "LicensedExtensionUpgradeJob");
    protected static final LocalDocumentReference NEW_VERSION_JOB_DOC = new LocalDocumentReference(CODE_SPACE, "NewExtensionVersionAvailableJob");
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionInstalledEvent());
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public LicensingSchedulerListener() {
        super(ROLE_HINT, EVENTS);
    }

    public void initialize() throws InitializationException {
        try {
            if (this.contextProvider.get() != null) {
                this.scheduleJob(true, EXTENSION_UPGRADE_JOB_DOC);
                this.scheduleJob(true, NEW_VERSION_JOB_DOC);
            }
        }
        catch (XWikiException | SchedulerException e) {
            this.logger.warn("An error occurred while rescheduling LicensedExtensionUpgradeJob, meaning automatic upgrades on pro apps might be affected. Please reschedule this job manually or contact support. ", e);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        String extensionId = ((DefaultInstalledExtension)source).getId().getId();
        if (event instanceof ExtensionInstalledEvent && extensionId.equals(LICENSOR_API_ID)) {
            try {
                this.scheduleJob(false, EXTENSION_UPGRADE_JOB_DOC);
                this.scheduleJob(false, NEW_VERSION_JOB_DOC);
            }
            catch (XWikiException | SchedulerException e) {
                throw new RuntimeException("Error while scheduling LicensedExtensionUpgradeJob after licensing install", e);
            }
        }
    }

    protected void scheduleJob(boolean doReschedule, LocalDocumentReference jobDocReference) throws XWikiException, SchedulerException {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        SchedulerPlugin scheduler = (SchedulerPlugin)xcontext.getWiki().getPluginManager().getPlugin("scheduler");
        XWikiDocument jobDoc = xcontext.getWiki().getDocument((EntityReference)jobDocReference, xcontext);
        BaseObject job = jobDoc.getXObject(SchedulerPlugin.XWIKI_JOB_CLASSREFERENCE);
        JobState jobState = scheduler.getJobStatus(job, xcontext);
        if (doReschedule && jobState.getQuartzState().equals((Object)Trigger.TriggerState.NORMAL)) {
            scheduler.unscheduleJob(job, xcontext);
            scheduler.scheduleJob(job, xcontext);
        } else if (jobState.getQuartzState().equals((Object)Trigger.TriggerState.NONE)) {
            scheduler.scheduleJob(job, xcontext);
        }
    }
}

