/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.upgrades;

import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensingConfiguration;
import com.xwiki.licensing.internal.upgrades.UpgradeExtensionHandler;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component(roles={LicensedExtensionUpgradeManager.class})
@Singleton
public class LicensedExtensionUpgradeManager {
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private UpgradeExtensionHandler upgradeExtensionHandler;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    @Inject
    private LicensingConfiguration licensingConfig;

    public void upgradeLicensedExtensions() {
        List<String> allowlist = this.licensingConfig.getAutoUpgradeAllowList();
        for (ExtensionId extensionId : this.licensedExtensionManager.getLicensedExtensions()) {
            if (!allowlist.contains(extensionId.getId())) continue;
            InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(extensionId);
            Collection namespaces = installedExtension.getNamespaces();
            if (namespaces == null) {
                this.upgradeExtensionHandler.tryUpgradeExtensionToLastVersion(installedExtension, null);
                continue;
            }
            for (String namespace : installedExtension.getNamespaces()) {
                this.upgradeExtensionHandler.tryUpgradeExtensionToLastVersion(installedExtension, namespace);
            }
        }
    }
}

