/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.helpers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component(roles={HttpClientUtils.class})
@Singleton
public class HttpClientUtils {
    @Inject
    private Logger logger;

    public JsonNode httpPost(HttpPost httpPost, String errorMsg) {
        JsonNode jsonNode;
        block8: {
            CloseableHttpClient client = HttpClients.createDefault();
            try {
                JsonFactory jsonFactory = new JsonFactory();
                ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
                jsonNode = (JsonNode)client.execute((ClassicHttpRequest)httpPost, response -> {
                    HttpEntity responseEntity = response.getEntity();
                    if (responseEntity == null) {
                        return null;
                    }
                    try (InputStream inputStream = responseEntity.getContent();){
                        JsonNode jsonNode = objectMapper.readTree(inputStream);
                        return jsonNode;
                    }
                });
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.error("{} Root cause: [{}]", (Object)errorMsg, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    return null;
                }
            }
            client.close();
        }
        return jsonNode;
    }
}

