/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import java.lang.reflect.Field;
import org.xwiki.component.phase.InitializationException;

public final class LicensingUtils {
    private LicensingUtils() {
    }

    public static void checkIntegrity(Object ... instances) throws InitializationException {
        for (Object instance : instances) {
            if (LicensingUtils.isPristineImpl(instance)) continue;
            throw new InitializationException("Integrity check failed while loading the licensor.");
        }
    }

    public static boolean isPristineImpl(Object instance) {
        return LicensingUtils.class.getProtectionDomain().getCodeSource().equals(instance.getClass().getProtectionDomain().getCodeSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getFieldValue(Object instanceContainingField, String fieldName) {
        for (Class<?> targetClass = instanceContainingField.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                boolean isAccessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object object = field.get(instanceContainingField);
                    field.setAccessible(isAccessible);
                    return object;
                }
                catch (Throwable throwable) {
                    try {
                        field.setAccessible(isAccessible);
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to get field [" + fieldName + "] in instance of [" + instanceContainingField.getClass().getName() + "]. The Java Security Manager has probably been configured to prevent getting private field values. This extension requires this ability to work.", e);
                    }
                }
            }
        }
        return null;
    }
}

