/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import com.xwiki.licensing.License;
import com.xwiki.licensing.internal.enforcer.EntityLicenseManager;
import com.xwiki.licensing.internal.enforcer.LicensedEntity;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.authorization.internal.AbstractSecurityRuleEntry;

@Component
@Named(value="licensing")
@Singleton
public class LicensingSecurityEntryReader
implements SecurityEntryReader,
Initializable,
Disposable {
    public static final String HINT = "licensing";
    private static final String SECURITY_ENTRY_READER_FIELD = "securityEntryReader";
    @Inject
    private Logger logger;
    @Inject
    private SecurityCacheLoader securityCacheLoader;
    @Inject
    private SecurityEntryReader securityEntryReader;
    @Inject
    private EntityLicenseManager licenseManager;

    public void initialize() throws InitializationException {
        if (!LicensingUtils.isPristineImpl(this.licenseManager)) {
            this.licenseManager = null;
        }
        this.logger.debug("Replacing [{}] with myself.", (Object)this.securityEntryReader);
        ReflectionUtils.setFieldValue((Object)this.securityCacheLoader, (String)SECURITY_ENTRY_READER_FIELD, (Object)this);
    }

    public void dispose() throws ComponentLifecycleException {
        if (LicensingUtils.getFieldValue(this.securityCacheLoader, SECURITY_ENTRY_READER_FIELD) == this) {
            this.logger.debug("Replacing myself by [{}].", (Object)this.securityEntryReader);
            ReflectionUtils.setFieldValue((Object)this.securityCacheLoader, (String)SECURITY_ENTRY_READER_FIELD, (Object)this.securityEntryReader);
        }
    }

    public SecurityRuleEntry read(SecurityReference securityReference) throws AuthorizationException {
        EntityReference ref = securityReference.getOriginalReference();
        if (ref != null) {
            License license;
            this.logger.debug("Checking license applicability for [{}].", (Object)ref);
            License license2 = license = this.licenseManager != null ? this.licenseManager.get(ref) : License.UNLICENSED;
            if (license != null) {
                return new InternalSecurityRuleEntry(this.securityEntryReader.read(securityReference), license);
            }
        }
        return this.securityEntryReader.read(securityReference);
    }

    private final class InternalSecurityRuleEntry
    extends AbstractSecurityRuleEntry
    implements LicensedEntity {
        private final SecurityReference reference;
        private final Collection<SecurityRule> rules;
        private final License license;

        private InternalSecurityRuleEntry(SecurityRuleEntry entry, License license) {
            this.reference = entry.getReference();
            this.rules = entry.getRules();
            this.license = license;
        }

        public SecurityReference getReference() {
            return this.reference;
        }

        public Collection<SecurityRule> getRules() {
            return this.rules;
        }

        @Override
        public License getLicense() {
            return this.license;
        }
    }
}

