/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.SecurityEntryReader;

@Component
@Singleton
@Named(value="LicensingInitializerListener")
public class LicensingInitializer
extends AbstractEventListener
implements Initializable {
    public static final String HINT = "LicensingInitializerListener";
    @Inject
    private Logger logger;
    @Inject
    private Provider<LicenseManager> licenseManagerProvider;
    @Inject
    @Named(value="licensing")
    private Provider<AuthorizationSettler> licensingAuthorizationSettlerProvider;
    @Inject
    @Named(value="licensing")
    private Provider<SecurityEntryReader> licensingSecurityEntryReaderProvider;
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> readOnlyXWikiContextProvider;
    @Inject
    private Provider<InstalledExtensionRepository> installedExtensionRepositoryProvider;

    public LicensingInitializer() {
        super(HINT, new Event[]{new ApplicationReadyEvent(), new ExtensionInstalledEvent(new ExtensionId("com.xwiki.licensing:application-licensing-licensor-api"), null)});
    }

    public void initialize() throws InitializationException {
        boolean databaseReady = this.readOnlyXWikiContextProvider.get() != null;
        InstalledExtension licensorExtension = ((InstalledExtensionRepository)this.installedExtensionRepositoryProvider.get()).getInstalledExtension("com.xwiki.licensing:application-licensing-licensor-api", null);
        if (databaseReady && licensorExtension != null) {
            this.initializeLicensingSystem();
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        this.initializeLicensingSystem();
    }

    private void initializeLicensingSystem() {
        this.logger.debug("Initializing the licensing system.");
        try {
            if (!LicensingUtils.isPristineImpl(this.licensingAuthorizationSettlerProvider.get()) || !LicensingUtils.isPristineImpl(this.licensingSecurityEntryReaderProvider.get())) {
                this.logger.debug("Integrity check failed when getting authorization settler.");
                throw new Exception();
            }
            this.licenseManagerProvider.get();
        }
        catch (Exception e) {
            this.logger.error("The licensing system has failed to be properly initialized, this could affect your ability to use licensed extensions.");
        }
    }
}

