/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseValidator;
import com.xwiki.licensing.internal.enforcer.LicensedEntity;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import java.util.Collection;
import java.util.Deque;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityAccess;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractSecurityAccessEntry;
import org.xwiki.security.authorization.internal.XWikiSecurityAccess;

@Component
@Named(value="licensing")
@Singleton
public class LicensingAuthorizationSettler
implements AuthorizationSettler,
Initializable,
Disposable {
    public static final String HINT = "licensing";
    private static final String AUTHORIZATION_SETTLER_FIELD = "authorizationSettler";
    @Inject
    private Logger logger;
    @Inject
    private Provider<AuthorizationSettler> authorizationSettlerProvider;
    @Inject
    private Provider<LicenseValidator> licenseValidator;
    private LicenseValidator cachedLicenseValidator;
    private AuthorizationSettler authorizationSettler;

    public void initialize() throws InitializationException {
        this.authorizationSettler = (AuthorizationSettler)this.authorizationSettlerProvider.get();
        if (this.authorizationSettler instanceof LicensingAuthorizationSettler) {
            this.logger.debug("Getting the original authorization settler out of a copy of myself.");
            this.authorizationSettler = ((LicensingAuthorizationSettler)this.authorizationSettler).authorizationSettler;
        }
        this.logger.debug("Replacing [{}] with myself.", (Object)this.authorizationSettler);
        ReflectionUtils.setFieldValue(this.authorizationSettlerProvider, (String)AUTHORIZATION_SETTLER_FIELD, (Object)this);
    }

    private LicenseValidator getLicenseValidator() {
        if (this.cachedLicenseValidator == null) {
            this.cachedLicenseValidator = (LicenseValidator)this.licenseValidator.get();
            if (!LicensingUtils.isPristineImpl(this.cachedLicenseValidator)) {
                this.cachedLicenseValidator = LicenseValidator.INVALIDATOR;
            }
        }
        return this.cachedLicenseValidator;
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.authorizationSettlerProvider.get() == this) {
            this.logger.debug("Replacing myself by [{}].", (Object)this.authorizationSettler);
            ReflectionUtils.setFieldValue(this.authorizationSettlerProvider, (String)AUTHORIZATION_SETTLER_FIELD, (Object)this.authorizationSettler);
        }
    }

    public SecurityAccessEntry settle(UserSecurityReference userSecurityReference, Collection<GroupSecurityReference> collection, Deque<SecurityRuleEntry> deque) {
        Object accessEntry = this.authorizationSettler.settle(userSecurityReference, collection, deque);
        SecurityRuleEntry ruleEntry = deque.peek();
        DocumentReference user = userSecurityReference.getOriginalDocumentReference();
        SecurityReference secRef = deque.peek().getReference();
        EntityReference ref = secRef.getOriginalReference();
        if (ruleEntry instanceof LicensedEntity) {
            License license = ((LicensedEntity)ruleEntry).getLicense();
            InternalSecurityAccess access = new InternalSecurityAccess(accessEntry.getAccess());
            if (!this.getLicenseValidator().isValid(license)) {
                this.logger.debug("Applying invalid license [{}] to [{}].", (Object)license.getId().toString(), (Object)ref);
                access.deny(Right.VIEW);
                access.deny(Right.COMMENT);
                access.deny(Right.ADMIN);
                access.deny(Right.PROGRAM);
            } else {
                this.logger.debug("Applying valid license [{}] to [{}].", (Object)license.getId().toString(), (Object)ref);
            }
            access.deny(Right.EDIT);
            access.deny(Right.DELETE);
            access.deny(Right.CREATOR);
            accessEntry = new InternalSecurityAccessEntry((SecurityAccessEntry)accessEntry, (SecurityAccess)access);
        }
        this.logger.debug("Settling done for user [{}] and entity [{}] with access [{}].", new Object[]{user, ref, accessEntry.getAccess()});
        return accessEntry;
    }

    private class InternalSecurityAccess
    extends XWikiSecurityAccess {
        InternalSecurityAccess(SecurityAccess access) {
            for (Right right : Right.values()) {
                this.set(right, access.get(right));
            }
        }

        void set(Right right, RuleState state) {
            switch (state) {
                case ALLOW: {
                    this.allow(right);
                    break;
                }
                case DENY: {
                    this.deny(right);
                    break;
                }
                case UNDETERMINED: {
                    this.clear(right);
                    break;
                }
            }
        }

        void allow(Right right) {
            this.allowed.add(right);
            this.denied.remove((Object)right);
        }

        void deny(Right right) {
            this.denied.add(right);
            this.allowed.remove((Object)right);
        }

        void clear(Right right) {
            this.allowed.remove((Object)right);
            this.denied.remove((Object)right);
        }
    }

    private final class InternalSecurityAccessEntry
    extends AbstractSecurityAccessEntry {
        private final UserSecurityReference userReference;
        private final SecurityReference reference;
        private final SecurityAccess access;

        InternalSecurityAccessEntry(SecurityAccessEntry entry, SecurityAccess access) {
            this.userReference = entry.getUserReference();
            this.reference = entry.getReference();
            this.access = access;
        }

        public UserSecurityReference getUserReference() {
            return this.userReference;
        }

        public SecurityAccess getAccess() {
            return this.access;
        }

        public SecurityReference getReference() {
            return this.reference;
        }
    }
}

