/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.LicenseValidator;
import com.xwiki.licensing.Licensor;
import com.xwiki.licensing.internal.enforcer.EntityLicenseManager;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultLicensor
implements Licensor,
Initializable {
    private static final int EXPIRATION_THRESHOLD = 10;
    @Inject
    private LicenseManager licenseManager;
    @Inject
    private LicenseValidator licenseValidator;
    @Inject
    private EntityLicenseManager entityLicenseManager;
    @Inject
    private Provider<XWikiContext> context;

    public void initialize() throws InitializationException {
        LicensingUtils.checkIntegrity(this.licenseManager, this.licenseValidator, this.entityLicenseManager);
    }

    @Override
    public License getLicense() {
        try {
            return this.getLicense((EntityReference)((XWikiContext)this.context.get()).getDoc().getDocumentReference());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public License getLicense(EntityReference reference) {
        try {
            return this.entityLicenseManager.get(reference);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public License getLicense(ExtensionId extensionId) {
        try {
            return this.licenseManager.get(extensionId);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public boolean hasLicensure() {
        License license = this.getLicense();
        return license == null || this.licenseValidator.isValid(license);
    }

    @Override
    public boolean hasLicensure(EntityReference reference) {
        License license = this.getLicense(reference);
        return license == null || this.licenseValidator.isValid(license);
    }

    @Override
    public boolean hasLicensure(ExtensionId extensionId) {
        License license = this.getLicense(extensionId);
        return license == null || this.licenseValidator.isValid(license);
    }

    @Override
    public boolean isLicenseExpiring(ExtensionId extensionId) {
        License license = this.getLicense(extensionId);
        if (license == null) {
            return false;
        }
        LocalDate expirationDate = Instant.ofEpochMilli(license.getExpirationDate()).atZone(ZoneId.systemDefault()).toLocalDate();
        long daysUntilExpiration = ChronoUnit.DAYS.between(LocalDate.now(), expirationDate);
        return daysUntilExpiration <= 10L && daysUntilExpiration > 0L;
    }
}

