/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import com.xwiki.licensing.internal.enforcer.LicensingSecurityCacheRuleInvalidator;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.xar.XarEntry;

@Component
@Singleton
public class DefaultLicensingSecurityCacheRuleInvalidator
implements LicensingSecurityCacheRuleInvalidator {
    private static final String WIKI_NAMESPACE = "wiki:";
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityReferenceFactory securityReferenceFactory;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    @Override
    public void invalidate(XarInstalledExtension extension) {
        Collection namespaces = extension.getNamespaces();
        if (namespaces != null) {
            for (String namespace : namespaces) {
                if (!namespace.startsWith(WIKI_NAMESPACE)) continue;
                this.invalidateForWiki(extension, new WikiReference(namespace.substring(WIKI_NAMESPACE.length())));
            }
        } else {
            try {
                for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                    this.invalidateForWiki(extension, new WikiReference(wikiId));
                }
            }
            catch (WikiManagerException e) {
                this.logger.error("Failed to invalidate the cache for the extension [{}] on the farm", (Object)extension.getId(), (Object)e);
            }
        }
    }

    private void invalidateForWiki(XarInstalledExtension extension, WikiReference wikiReference) {
        for (XarEntry entry : extension.getXarPackage().getEntries()) {
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)this.documentReferenceResolver.resolve((Object)entry, new Object[]{wikiReference})));
        }
    }
}

