/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal.enforcer;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.internal.enforcer.EntityLicenseManager;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultEntityLicenseManager
implements EntityLicenseManager {
    protected static final License FREE = new License();
    private static final Pattern LIST_SEPARATOR = Pattern.compile("\\s*,\\s*");
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private Provider<LicenseManager> licenseManagerProvider;
    private LicenseManager licenseManager;

    private LicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = (LicenseManager)this.licenseManagerProvider.get();
            if (!LicensingUtils.isPristineImpl(this.licenseManager)) {
                throw new RuntimeException("The licensure engine has been tampered. Your XWiki instance will be seriously impacted.");
            }
        }
        return this.licenseManager;
    }

    @Override
    public License get(EntityReference reference) {
        List<License> licenses = this.getLicenses(reference);
        if (licenses.isEmpty()) {
            return null;
        }
        return License.getOptimumLicense(licenses);
    }

    private List<License> getLicenses(EntityReference reference) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (XarInstalledExtension extension : this.getMatchingExtensions(reference)) {
            License license = this.getLicenseManager().get(extension.getId());
            if (license == null || this.isExcludedDocument(reference, extension)) continue;
            licenses.add(this.isPublicDocument(reference, extension) ? FREE : license);
        }
        return licenses;
    }

    private boolean isPublicDocument(EntityReference reference, XarInstalledExtension extension) {
        return this.isListedIn(reference, extension, "xwiki.extension.licensing.publicDocuments");
    }

    private boolean isExcludedDocument(EntityReference reference, XarInstalledExtension extension) {
        return this.isListedIn(reference, extension, "xwiki.extension.licensing.excludedDocuments");
    }

    private boolean isListedIn(EntityReference reference, XarInstalledExtension extension, String propertyName) {
        EntityReference documentReference = reference.extractReference(EntityType.DOCUMENT);
        if (documentReference != null) {
            String joinedList = (String)extension.getProperty(propertyName, (Object)"");
            List<String> list = Arrays.asList(LIST_SEPARATOR.split(joinedList.trim()));
            return list.contains(this.localEntityReferenceSerializer.serialize(documentReference, new Object[0]));
        }
        return false;
    }

    private Collection<XarInstalledExtension> getMatchingExtensions(EntityReference reference) {
        EntityReference documentReference = reference.extractReference(EntityType.DOCUMENT);
        if (documentReference != null) {
            return ((XarInstalledExtensionRepository)this.installedExtensionRepository).getXarInstalledExtensions(new DocumentReference(documentReference));
        }
        return Collections.emptyList();
    }
}

