/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component(roles={UserCounter.class})
@Singleton
public class UserCounter {
    @Inject
    private Logger logger;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;
    private Long cachedUserCount;

    public long getUserCount() throws Exception {
        if (this.cachedUserCount == null) {
            try {
                long userCount = 0L;
                for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                    userCount += this.getUserCountOnWiki(wikiId);
                }
                this.logger.debug("User count is [{}].", (Object)userCount);
                this.cachedUserCount = userCount;
            }
            catch (QueryException | WikiManagerException e) {
                throw new Exception("Failed to count the users.", e);
            }
        }
        return this.cachedUserCount;
    }

    private long getUserCountOnWiki(String wikiId) throws QueryException {
        StringBuilder statement = new StringBuilder(", BaseObject as obj, IntegerProperty as prop ");
        statement.append("where doc.fullName = obj.name and obj.className = 'XWiki.XWikiUsers' and ");
        statement.append("prop.id.id = obj.id and prop.id.name = 'active' and prop.value = '1'");
        Query query = this.queryManager.createQuery(statement.toString(), "hql");
        query.addFilter(this.countFilter).setWiki(wikiId);
        List results = query.execute();
        return (Long)results.get(0);
    }

    @Component
    @Singleton
    @Named(value="com.xwiki.licensing.internal.UserCounter.UserListener")
    public static class UserListener
    extends AbstractEventListener {
        public static final String HINT = "com.xwiki.licensing.internal.UserCounter.UserListener";
        protected static final String ACTIVE = "active";
        protected static final LocalDocumentReference USER_CLASS = new LocalDocumentReference("XWiki", "XWikiUsers");
        @Inject
        private UserCounter userCounter;

        public UserListener() {
            super(HINT, Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent()));
        }

        public void onEvent(Event event, Object source, Object data) {
            int oldActive;
            XWikiDocument newDocument = (XWikiDocument)source;
            XWikiDocument oldDocument = newDocument.getOriginalDocument();
            BaseObject newObject = newDocument.getXObject((EntityReference)USER_CLASS);
            BaseObject oldObject = oldDocument.getXObject((EntityReference)USER_CLASS);
            boolean newDocumentIsUser = newObject != null;
            boolean oldDocumentIsUser = oldObject != null;
            int newActive = newDocumentIsUser ? newObject.getIntValue(ACTIVE) : -1;
            int n = oldActive = oldDocumentIsUser ? oldObject.getIntValue(ACTIVE) : -1;
            if (newDocumentIsUser != oldDocumentIsUser || newActive != oldActive) {
                this.userCounter.cachedUserCount = null;
            }
        }
    }
}

