/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseUpdater;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensingConfiguration;
import com.xwiki.licensing.Licensor;
import com.xwiki.licensing.internal.UserCounter;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.instance.InstanceIdManager;

@Component(roles={TrialLicenseGenerator.class})
@Singleton
public class TrialLicenseGenerator {
    private static final String FEATURE_ID = "featureId";
    private static final String INSTANCE_ID = "instanceId";
    @Inject
    private Logger logger;
    @Inject
    private Provider<InstanceIdManager> instanceIdManagerProvider;
    @Inject
    private UserCounter userCounter;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    @Inject
    private LicensingConfiguration licensingConfig;
    @Inject
    private Provider<Licensor> licensorProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private LicenseUpdater licenseUpdater;

    public void generateTrialLicense(ExtensionId extensionId) {
        try {
            URL trialURL = this.getTrialURL(extensionId);
            if (trialURL == null) {
                this.logger.warn("Failed to add trial license for [{}] because the licensor configuration is not complete. Check your store trial URL and owner details.", (Object)extensionId.getId());
                return;
            }
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            String getTrialResponse = xcontext.getWiki().getURLContent(trialURL.toString(), xcontext);
            if (getTrialResponse.contains("error")) {
                this.logger.warn("Failed to generate trial license for [{}] on store.", (Object)extensionId.getId());
            } else {
                this.logger.debug("Trial license added for [{}]", (Object)extensionId.getId());
                this.licenseUpdater.updateLicenses();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to get trial license for [{}]. Root cause is [{}]", (Object)extensionId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public Boolean canGenerateTrialLicense(ExtensionId extensionId) {
        return License.UNLICENSED.equals((Object)((Licensor)this.licensorProvider.get()).getLicense(extensionId)) && this.isOwnerDataComplete() != false && this.isMandatoryLicensedExtension(extensionId) != false;
    }

    private URL getTrialURL(ExtensionId extensionId) throws Exception {
        String storeTrialURL = this.licensingConfig.getStoreTrialURL();
        if (storeTrialURL == null) {
            return null;
        }
        URIBuilder builder = new URIBuilder(storeTrialURL);
        builder.addParameter("firstName", this.licensingConfig.getLicensingOwnerFirstName());
        builder.addParameter("lastName", this.licensingConfig.getLicensingOwnerLastName());
        builder.addParameter("email", this.licensingConfig.getLicensingOwnerEmail());
        builder.addParameter(INSTANCE_ID, ((InstanceIdManager)this.instanceIdManagerProvider.get()).getInstanceId().toString());
        builder.addParameter(FEATURE_ID, extensionId.getId());
        builder.addParameter("extensionVersion", extensionId.getVersion().getValue());
        builder.addParameter("licenseType", "TRIAL");
        builder.addParameter("userCount", String.valueOf(this.userCounter.getUserCount()));
        return builder.build().toURL();
    }

    private Boolean isMandatoryLicensedExtension(ExtensionId extensionId) {
        return this.licensedExtensionManager.getMandatoryLicensedExtensions().contains(extensionId);
    }

    private Boolean isOwnerDataComplete() {
        return !StringUtils.isEmpty((CharSequence)this.licensingConfig.getLicensingOwnerLastName()) && !StringUtils.isEmpty((CharSequence)this.licensingConfig.getLicensingOwnerFirstName()) && !StringUtils.isEmpty((CharSequence)this.licensingConfig.getLicensingOwnerEmail());
    }
}

