/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component(roles={LicensedDependenciesMap.class})
@Singleton
public class LicensedDependenciesMap {
    private Map<String, Set<LicensedExtensionParent>> cachedLicensedDependenciesMap;
    @Inject
    private Logger logger;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;

    public Map<String, Set<LicensedExtensionParent>> get(Collection<ExtensionId> licensedExtensions) {
        if (this.cachedLicensedDependenciesMap == null) {
            this.logger.debug("Licensed dependencies map is not cached, computing it.");
            this.cachedLicensedDependenciesMap = this.computeLicensedDependenciesMap(licensedExtensions);
        } else {
            this.logger.debug("Licensed dependencies map is cached, returning it.");
        }
        return this.cachedLicensedDependenciesMap;
    }

    public void invalidateCache() {
        this.logger.debug("Clear licensed dependency map cache.");
        this.cachedLicensedDependenciesMap = null;
    }

    private synchronized Map<String, Set<LicensedExtensionParent>> computeLicensedDependenciesMap(Collection<ExtensionId> allLicensedExtensions) {
        HashMap<String, Set<LicensedExtensionParent>> licensedDependenciesMap = new HashMap<String, Set<LicensedExtensionParent>>();
        HashSet<ExtensionId> verifiedExtensions = new HashSet<ExtensionId>();
        for (ExtensionId extensionId : allLicensedExtensions) {
            InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId);
            if (installedExtension == null) continue;
            verifiedExtensions.add(extensionId);
            Collection namespaces = installedExtension.getNamespaces();
            if (namespaces == null) {
                this.logger.debug("Computing licensed dependencies map for [{}] on root namespace.", (Object)extensionId);
                installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId.getId(), null);
                this.getLicensedDependenciesMapRecursive(new LicensedExtensionParent(installedExtension.getName(), installedExtension.getId().getId(), null), installedExtension.getDependencies(), allLicensedExtensions, verifiedExtensions, licensedDependenciesMap);
                continue;
            }
            for (String namespace : namespaces) {
                this.logger.debug("Computing licensed dependencies map for [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
                installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId.getId(), namespace);
                this.getLicensedDependenciesMapRecursive(new LicensedExtensionParent(installedExtension.getName(), installedExtension.getId().getId(), namespace), installedExtension.getDependencies(), allLicensedExtensions, verifiedExtensions, licensedDependenciesMap);
            }
        }
        this.logger.debug("Computed map of licensed dependencies: [{}]", licensedDependenciesMap);
        return licensedDependenciesMap;
    }

    private void getLicensedDependenciesMapRecursive(LicensedExtensionParent licensedExtensionParent, Collection<ExtensionDependency> dependencies, Collection<ExtensionId> installedLicensedExtensions, Set<ExtensionId> verifiedExtensions, Map<String, Set<LicensedExtensionParent>> licensedDependenciesChain) {
        String namespace = licensedExtensionParent.getExtensionNamespace();
        for (ExtensionDependency dep : dependencies) {
            InstalledExtension installedDep = this.installedExtensionRepository.getInstalledExtension(dep.getId(), namespace);
            if (installedDep == null || dep.isOptional()) continue;
            LicensedExtensionParent extensionParent = licensedExtensionParent;
            if (installedLicensedExtensions.contains(installedDep.getId())) {
                this.addBackwardDependency(licensedExtensionParent, licensedDependenciesChain, installedDep.getId().getId());
                extensionParent = new LicensedExtensionParent(installedDep.getName(), installedDep.getId().getId(), namespace);
            }
            if (verifiedExtensions.contains(installedDep.getId())) continue;
            verifiedExtensions.add(installedDep.getId());
            this.getLicensedDependenciesMapRecursive(extensionParent, installedDep.getDependencies(), installedLicensedExtensions, verifiedExtensions, licensedDependenciesChain);
        }
    }

    private void addBackwardDependency(LicensedExtensionParent licensedExtensionParent, Map<String, Set<LicensedExtensionParent>> licensedDependenciesMap, String installedDepId) {
        if (licensedDependenciesMap.containsKey(installedDepId)) {
            licensedDependenciesMap.get(installedDepId).add(licensedExtensionParent);
        } else {
            licensedDependenciesMap.put(installedDepId, new HashSet<LicensedExtensionParent>(Arrays.asList(licensedExtensionParent)));
        }
    }

    public static class LicensedExtensionParent {
        private final String extensionName;
        private final String extensionId;
        private final String namespace;

        public LicensedExtensionParent(String extensionName, String extensionId, String namespace) {
            this.extensionName = extensionName;
            this.extensionId = extensionId;
            this.namespace = namespace;
        }

        public String getExtensionId() {
            return this.extensionId;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public String getExtensionNamespace() {
            return this.namespace;
        }
    }
}

