/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseUpdater;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.Licensor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="com.xwiki.licensing.internal.LicenseRenewListener")
@Singleton
public class LicenseRenewListener
implements EventListener {
    protected static final String NAME = "com.xwiki.licensing.internal.LicenseRenewListener";
    protected static final List<Event> EVENTS = Arrays.asList(new ExtensionInstalledEvent(), new ExtensionUpgradedEvent());
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private Provider<Licensor> licensorProvider;
    @Inject
    private LicenseUpdater licenseUpdater;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        this.licenseUpdater.updateLicenses();
        ExtensionEvent extensionEvent = (ExtensionEvent)event;
        if (this.licensedExtensionManager.getLicensedExtensions().contains(extensionEvent.getExtensionId()) && this.isMandatoryLicensedExtension(extensionEvent.getExtensionId())) {
            boolean hasLicense;
            InstalledExtension installedExtension = (InstalledExtension)source;
            License license = ((Licensor)this.licensorProvider.get()).getLicense(installedExtension.getId());
            boolean bl = hasLicense = license != null && !License.UNLICENSED.equals((Object)license);
            if (event instanceof ExtensionUpgradedEvent && hasLicense) {
                this.extensionUpgraded(installedExtension, data, extensionEvent, license);
            } else if (event instanceof ExtensionInstalledEvent) {
                this.extensionInstalled(installedExtension, extensionEvent, hasLicense);
            }
        }
    }

    private void extensionInstalled(InstalledExtension installedExtension, ExtensionEvent extensionEvent, boolean hasLicense) {
        if (hasLicense) {
            this.logger.debug("[{}] has been installed and it has a license associated to it. Check if there are license changes for this new extension version.", (Object)extensionEvent.getExtensionId());
            this.licenseUpdater.renewLicense(installedExtension.getId());
        }
    }

    private void extensionUpgraded(InstalledExtension installedExtension, Object data, ExtensionEvent extensionEvent, License license) {
        InstalledExtension prevInstalledExtension = this.getPreviousInstalledExtension(data, installedExtension, extensionEvent.getNamespace());
        if (prevInstalledExtension != null && prevInstalledExtension.getId().getVersion().compareTo((Object)installedExtension.getId().getVersion()) > 0) {
            this.logger.debug("The licensed extension [{}] has been downgraded. No license renew it's triggered.", (Object)extensionEvent.getExtensionId());
            return;
        }
        this.logger.debug("[{}] has been upgraded and it has a license associated to it. Checking if there are dependencies changes, in order to update its license too.", (Object)extensionEvent.getExtensionId());
        Set<ExtensionId> licensedDependencies = this.licensedExtensionManager.getLicensedDependencies(installedExtension, extensionEvent.getNamespace());
        Set<ExtensionId> previousDependencies = this.licensedExtensionManager.getLicensedDependencies(prevInstalledExtension, extensionEvent.getNamespace());
        if (!licensedDependencies.equals(previousDependencies) || this.licensedFeatureIdsChanges(license, installedExtension, licensedDependencies)) {
            this.logger.debug("There are licensed dependencies changes between old and current extension version.");
            this.licenseUpdater.renewLicense(installedExtension.getId());
        }
    }

    private boolean licensedFeatureIdsChanges(License license, InstalledExtension installedExtension, Set<ExtensionId> licensedDependencies) {
        boolean changedDependencies;
        List licenseFeatureIds = license.getFeatureIds().stream().map(LicensedFeatureId::getId).collect(Collectors.toList());
        licenseFeatureIds.removeIf(ext -> ext.equals(installedExtension.getId().getId()));
        List licensedDependenciesIds = licensedDependencies.stream().map(ExtensionId::getId).collect(Collectors.toList());
        boolean bl = changedDependencies = !CollectionUtils.isEqualCollection(licensedDependenciesIds, licenseFeatureIds);
        if (changedDependencies) {
            this.logger.debug("License contains outdated feature ids: [{}]. New feature ids:  [{}]", licenseFeatureIds, licensedDependenciesIds);
        }
        return changedDependencies;
    }

    private InstalledExtension getPreviousInstalledExtension(Object data, InstalledExtension installedExtension, String namespace) {
        for (InstalledExtension previousInstalledExtension : (Collection)data) {
            if (!previousInstalledExtension.getId().getId().equals(installedExtension.getId().getId())) continue;
            return previousInstalledExtension;
        }
        return null;
    }

    private boolean isMandatoryLicensedExtension(ExtensionId extensionId) {
        return this.licensedExtensionManager.getMandatoryLicensedExtensions().stream().map(ExtensionId::getId).collect(Collectors.toList()).contains(extensionId.getId());
    }
}

