/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.internal.DefaultLicenseManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.AbstractExtensionEvent;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="licenseManager")
@Singleton
public class LicenseManagerEventListener
implements EventListener {
    static final String NAME = "licenseManager";
    private static final List<Event> EVENTS = new ArrayList<AbstractExtensionEvent>(Arrays.asList(new ExtensionInstalledEvent(), new ExtensionUninstalledEvent(), new ExtensionUpgradedEvent()));
    @Inject
    private Provider<LicenseManager> licenseManagerProvider;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        ExtensionEvent extensionEvent = (ExtensionEvent)event;
        InstalledExtension installedExtension = (InstalledExtension)source;
        DefaultLicenseManager licenseManager = (DefaultLicenseManager)this.licenseManagerProvider.get();
        this.licensedExtensionManager.invalidateLicensedDependenciesMap();
        if (event instanceof ExtensionInstalledEvent) {
            licenseManager.installExtensionLicense(extensionEvent.getNamespace(), installedExtension);
        } else if (event instanceof ExtensionUninstalledEvent) {
            licenseManager.uninstallExtensionLicense(installedExtension);
        } else if (event instanceof ExtensionUpgradedEvent) {
            Collection previousExtensions = (Collection)data;
            for (InstalledExtension previousExtension : previousExtensions) {
                licenseManager.uninstallExtensionLicense(previousExtension);
            }
            licenseManager.installExtensionLicense(extensionEvent.getNamespace(), installedExtension);
        }
    }
}

