/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.LicenseUpdater;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.internal.TrialLicenseGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="GetTrialLicenseListener")
@Singleton
public class GetTrialLicenseListener
implements EventListener {
    protected static final String NAME = "GetTrialLicenseListener";
    protected static final List<Event> EVENTS = Arrays.asList(new JobFinishedEvent("install"));
    @Inject
    private TrialLicenseGenerator trialLicenseGenerator;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    @Inject
    private LicenseUpdater licenseUpdater;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        List extensions = (List)((JobFinishedEvent)event).getRequest().getProperty("extensions");
        this.licensedExtensionManager.invalidateMandatoryLicensedExtensionsCache();
        this.licenseUpdater.updateLicenses();
        for (ExtensionId extensionId : extensions) {
            InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId);
            Stack<ExtensionId> dependencyPath = new Stack<ExtensionId>();
            dependencyPath.push(extensionId);
            this.tryGenerateTrialLicenseRecursive(dependencyPath, installedExtension.getNamespaces());
        }
    }

    private void tryGenerateTrialLicenseRecursive(Stack<ExtensionId> dependencyPath, Collection<String> extensionNamespaces) {
        ExtensionId extensionId = dependencyPath.peek();
        if (this.trialLicenseGenerator.canGenerateTrialLicense(extensionId).booleanValue()) {
            this.trialLicenseGenerator.generateTrialLicense(extensionId);
        } else if (extensionNamespaces == null) {
            this.checkDependenciesForTrialLicense(extensionId, null, dependencyPath);
        } else {
            for (String namespace : extensionNamespaces) {
                this.checkDependenciesForTrialLicense(extensionId, namespace, dependencyPath);
            }
        }
    }

    private void checkDependenciesForTrialLicense(ExtensionId extensionId, String namespace, Stack<ExtensionId> dependencyPath) {
        InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId.getId(), namespace);
        if (installedExtension == null) {
            return;
        }
        Collection dependencies = installedExtension.getDependencies();
        for (ExtensionDependency dependency : dependencies) {
            InstalledExtension installedDependency = this.installedExtensionRepository.getInstalledExtension(dependency.getId(), namespace);
            if (installedDependency == null || dependencyPath.search(installedDependency.getId()) != -1) continue;
            dependencyPath.push(installedDependency.getId());
            this.tryGenerateTrialLicenseRecursive(dependencyPath, namespace != null ? Arrays.asList(namespace) : null);
        }
    }
}

