/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.LicensingConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;

@Component
@Singleton
public class DefaultLicensingConfiguration
implements LicensingConfiguration {
    private static final String CK_PREFIX = "licensing.";
    @Inject
    private Environment environment;
    @Inject
    private Provider<ConfigurationSource> configuration;
    @Inject
    @Named(value="LicensedExtensionAutomaticUpgrades")
    private ConfigurationSource automaticUpgradesConfig;
    @Inject
    @Named(value="LicensingStoreConfigurationSource")
    private ConfigurationSource storeConfig;
    @Inject
    @Named(value="LicensingOwnerConfigurationSource")
    private ConfigurationSource ownerConfig;
    private File localStorePath;

    @Override
    public File getLocalStorePath() {
        if (this.localStorePath == null) {
            String storePath = (String)((ConfigurationSource)this.configuration.get()).getProperty("licensing.localStorePath");
            this.localStorePath = storePath == null ? new File(this.environment.getPermanentDirectory(), "licenses") : new File(storePath);
        }
        return this.localStorePath;
    }

    @Override
    public List<String> getAutoUpgradeAllowList() {
        return this.convertObjectToStringList(this.automaticUpgradesConfig.getProperty("allowlist"));
    }

    @Override
    public String getStoreTrialURL() {
        return (String)this.storeConfig.getProperty("storeTrialURL");
    }

    @Override
    public String getStoreUpdateURL() {
        return (String)this.storeConfig.getProperty("storeUpdateURL");
    }

    @Override
    public String getLicensingOwnerFirstName() {
        return (String)this.ownerConfig.getProperty("firstName");
    }

    @Override
    public String getLicensingOwnerLastName() {
        return (String)this.ownerConfig.getProperty("lastName");
    }

    @Override
    public String getLicensingOwnerEmail() {
        return (String)this.ownerConfig.getProperty("email");
    }

    @Override
    public String getStoreRenewURL() {
        return (String)this.storeConfig.getProperty("storeRenewURL");
    }

    private List<String> convertObjectToStringList(Object list) {
        if (list instanceof List) {
            return ((List)list).stream().map(item -> Objects.toString(item, null)).collect(Collectors.toList());
        }
        if (list == null) {
            return Collections.emptyList();
        }
        throw new RuntimeException(String.format("Cannot convert [%s] to List", list));
    }
}

