/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.internal.LicensedDependenciesMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Singleton
public class DefaultLicensedExtensionManager
implements LicensedExtensionManager {
    public static final String LICENSOR_EXTENSION_ID = "com.xwiki.licensing:application-licensing-licensor-api";
    private Set<ExtensionId> cachedMandatoryLicensedExtensions;
    @Inject
    private Logger logger;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private LicensedDependenciesMap licensedDependenciesMap;

    @Override
    public Collection<ExtensionId> getLicensedExtensions() {
        return this.getLicensorBackwardDependencies().values().stream().flatMap(Collection::stream).map(Extension::getId).collect(Collectors.toSet());
    }

    @Override
    public Collection<ExtensionId> getLicensedExtensions(String namespace) {
        return ((Collection)Optional.ofNullable(this.getLicensorBackwardDependencies().get(namespace)).orElse(Collections.emptySet())).stream().map(Extension::getId).collect(Collectors.toSet());
    }

    @Override
    public Collection<ExtensionId> getLicensedExtensions(LicensedFeatureId licensedFeatureId) {
        ArrayList<ExtensionId> coveredExtensions = new ArrayList<ExtensionId>();
        ExtensionDependency extensionDependency = licensedFeatureId.getExtensionDependency();
        for (Extension extension : this.installedExtensionRepository.getInstalledExtensions()) {
            if (!extensionDependency.isCompatible(extension)) continue;
            coveredExtensions.add(extension.getId());
        }
        return coveredExtensions;
    }

    private Map<String, Collection<InstalledExtension>> getLicensorBackwardDependencies() {
        InstalledExtension licensorExtension = this.installedExtensionRepository.getInstalledExtension(LICENSOR_EXTENSION_ID, null);
        if (licensorExtension != null) {
            try {
                return this.installedExtensionRepository.getBackwardDependencies(licensorExtension.getId());
            }
            catch (ResolveException e) {
                this.logger.error("Failed to detect the licensed extensions.", (Throwable)e);
            }
        } else {
            this.logger.warn("The Licensor API extension ({}) is not installed on the root namespace as it should. Licensed extensions won't be detected correctly as a conseuence.", (Object)LICENSOR_EXTENSION_ID);
        }
        return Collections.emptyMap();
    }

    public Set<ExtensionId> getMandatoryLicensedExtensions() {
        Set<ExtensionId> mandatoryLicensedExtensions = this.cachedMandatoryLicensedExtensions;
        if (mandatoryLicensedExtensions == null) {
            this.cachedMandatoryLicensedExtensions = mandatoryLicensedExtensions = this.computeMandatoryLicensedExtensions();
        }
        return Collections.unmodifiableSet(mandatoryLicensedExtensions);
    }

    private synchronized Set<ExtensionId> computeMandatoryLicensedExtensions() {
        Set<ExtensionId> mandatoryLicensedExtensions = this.cachedMandatoryLicensedExtensions;
        if (mandatoryLicensedExtensions != null) {
            return mandatoryLicensedExtensions;
        }
        Collection<ExtensionId> allLicensedExtensions = this.getLicensedExtensions();
        HashSet<ExtensionId> verifiedExtensions = new HashSet<ExtensionId>();
        mandatoryLicensedExtensions = new HashSet<ExtensionId>(allLicensedExtensions);
        for (ExtensionId extensionId : allLicensedExtensions) {
            InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId);
            if (installedExtension == null) continue;
            verifiedExtensions.add(extensionId);
            Collection namespaces = installedExtension.getNamespaces();
            if (namespaces == null) {
                this.searchLicensedDependenciesRecursive(this.installedExtensionRepository.getInstalledExtension(extensionId.getId(), null), null, verifiedExtensions, mandatoryLicensedExtensions);
                continue;
            }
            for (String namespace : namespaces) {
                this.searchLicensedDependenciesRecursive(this.installedExtensionRepository.getInstalledExtension(extensionId.getId(), namespace), namespace, verifiedExtensions, mandatoryLicensedExtensions);
            }
        }
        return mandatoryLicensedExtensions;
    }

    private void searchLicensedDependenciesRecursive(InstalledExtension installedExtension, String namespace, Collection<ExtensionId> verifiedExtensions, Set<ExtensionId> mandatoryLicensedExtensions) {
        Collection dependencies = installedExtension.getDependencies();
        for (ExtensionDependency dependency : dependencies) {
            InstalledExtension installedDependency = this.installedExtensionRepository.getInstalledExtension(dependency.getId(), namespace);
            if (installedDependency == null || dependency.isOptional()) continue;
            ExtensionId dependencyId = installedDependency.getId();
            mandatoryLicensedExtensions.remove(dependencyId);
            if (verifiedExtensions.contains(dependencyId)) continue;
            verifiedExtensions.add(dependencyId);
            this.searchLicensedDependenciesRecursive(installedDependency, namespace, verifiedExtensions, mandatoryLicensedExtensions);
        }
    }

    @Override
    public void invalidateMandatoryLicensedExtensionsCache() {
        this.cachedMandatoryLicensedExtensions = null;
    }

    @Override
    public Set<ExtensionId> getLicensedDependencies(InstalledExtension installedExtension, String namespace) {
        HashSet<ExtensionId> licensedDependencies = new HashSet<ExtensionId>();
        HashSet<ExtensionId> verifiedExtensions = new HashSet<ExtensionId>();
        this.getLicensedDependencies(installedExtension, namespace, this.getLicensedExtensions(), licensedDependencies, verifiedExtensions);
        this.logger.debug("Found licensed dependencies for extension [{}] : [{}]", (Object)installedExtension.getId(), licensedDependencies);
        return licensedDependencies;
    }

    @Override
    public Map<String, Set<LicensedDependenciesMap.LicensedExtensionParent>> getLicensedDependenciesMap() {
        return this.licensedDependenciesMap.get(this.getLicensedExtensions());
    }

    @Override
    public void invalidateLicensedDependenciesMap() {
        this.licensedDependenciesMap.invalidateCache();
    }

    private void getLicensedDependencies(InstalledExtension installedExtension, String namespace, Collection<ExtensionId> installedLicensedExtensions, Set<ExtensionId> licensedDependencies, Set<ExtensionId> verifiedExtensions) {
        Collection dependencies = installedExtension.getDependencies();
        for (ExtensionDependency dep : dependencies) {
            InstalledExtension installedDep = this.installedExtensionRepository.getInstalledExtension(dep.getId(), namespace);
            if (installedDep == null || licensedDependencies.contains(installedDep.getId()) || verifiedExtensions.contains(installedDep.getId())) continue;
            if (installedLicensedExtensions.contains(installedDep.getId()) && !dep.isOptional()) {
                licensedDependencies.add(installedDep.getId());
            }
            verifiedExtensions.add(installedDep.getId());
            this.getLicensedDependencies(installedDep, namespace, installedLicensedExtensions, licensedDependencies, verifiedExtensions);
        }
    }
}

