/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseType;
import com.xwiki.licensing.LicenseValidator;
import com.xwiki.licensing.SignedLicense;
import com.xwiki.licensing.internal.UserCounter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.instance.InstanceIdManager;

@Component
@Singleton
public class DefaultLicenseValidator
implements LicenseValidator {
    private static final Map<LicenseType, List<String>> VALID_CERTIFICATES = new HashMap<LicenseType, List<String>>();
    private static final List<String> REVOKED_CERTIFICATES;
    @Inject
    private Logger logger;
    @Inject
    private UserCounter userCounter;
    @Inject
    private Provider<InstanceIdManager> instanceIdManagerProvider;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64Encoder;

    @Override
    public boolean isApplicable(License license) {
        return license.isApplicableTo(((InstanceIdManager)this.instanceIdManagerProvider.get()).getInstanceId());
    }

    @Override
    public boolean isSigned(License license) {
        return license instanceof SignedLicense && this.checkCertificates(license, ((SignedLicense)license).getCertificates());
    }

    private boolean checkCertificates(License license, Collection<X509CertifiedPublicKey> certificates) {
        if (certificates.size() < 3) {
            return false;
        }
        Iterator<X509CertifiedPublicKey> iterator = certificates.iterator();
        iterator.next();
        try {
            if (!VALID_CERTIFICATES.get(license.getType()).contains(this.base64Encoder.encode(iterator.next().getSubjectKeyIdentifier()))) {
                return false;
            }
            while (iterator.hasNext()) {
                if (!REVOKED_CERTIFICATES.contains(this.base64Encoder.encode(iterator.next().getSubjectKeyIdentifier()))) continue;
                return false;
            }
        }
        catch (IOException exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(License license) {
        return license.getExpirationDate() >= new Date().getTime() && this.checkUserCount(license);
    }

    private boolean checkUserCount(License license) {
        long maxUserCount = license.getMaxUserCount();
        try {
            return maxUserCount < 0L || maxUserCount >= this.userCounter.getUserCount();
        }
        catch (Exception e) {
            this.logger.warn("Failed to check the user limit. Assuming the license is not valid. Root cause is: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }

    static {
        VALID_CERTIFICATES.put(LicenseType.FREE, Arrays.asList("eicpWbt5RNWbOa4uiDqK5aOpr0E="));
        VALID_CERTIFICATES.put(LicenseType.TRIAL, Arrays.asList("o6yt/slI4P6qUQF8dpC5yYaJDA4="));
        VALID_CERTIFICATES.put(LicenseType.PAID, Arrays.asList("HW571yMdXhhx59oF96hKBNgh30M="));
        REVOKED_CERTIFICATES = Collections.emptyList();
    }
}

