/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.LicenseUpdater;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensingConfiguration;
import com.xwiki.licensing.Licensor;
import com.xwiki.licensing.internal.helpers.HttpClientUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.instance.InstanceIdManager;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class DefaultLicenseUpdater
implements LicenseUpdater {
    private static final String OUTPUT_SYNTAX = "outputSyntax";
    private static final String PLAIN = "plain";
    private static final String DATA = "data";
    private static final String ERROR = "Failed to update license for [%s]. Please contact your administrator for eventual problems.";
    private static final String FEATURE_ID = "featureId";
    private static final String INSTANCE_ID = "instanceId";
    @Inject
    private Logger logger;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private LicensingConfiguration licensingConfig;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Provider<InstanceIdManager> instanceIdManagerProvider;
    @Inject
    private Provider<Licensor> licensorProvider;
    @Inject
    private Provider<LicenseManager> licenseManagerProvider;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64decoder;
    @Inject
    private Converter<License> converter;
    @Inject
    private HttpClientUtils httpUtils;

    @Override
    public void renewLicense(ExtensionId extensionId) {
        String errorMsg = String.format(ERROR, extensionId);
        try {
            this.logger.debug("Try renewing the license of [{}], in order to include new found changes.", (Object)extensionId);
            JsonNode licenseRenewResponse = this.httpUtils.httpPost(this.initializeLicenseRenewPost(extensionId), errorMsg);
            if (licenseRenewResponse == null) {
                return;
            }
            if (licenseRenewResponse.get("status").textValue().equals("error")) {
                this.logger.warn("{} Cause: [{}]", (Object)errorMsg, (Object)licenseRenewResponse.get(DATA).textValue());
            } else {
                this.logger.debug("Successful response from store after license renew. Trying to update local licenses too.");
                String license = licenseRenewResponse.get("license").textValue();
                if (license != null) {
                    License retrivedLicense = (License)this.converter.convert(License.class, (Object)this.base64decoder.decode(license));
                    if (retrivedLicense != null) {
                        ((LicenseManager)this.licenseManagerProvider.get()).add(retrivedLicense);
                        this.logger.debug("License renewed for [{}].", (Object)extensionId.getId());
                    }
                } else {
                    this.logger.debug("No license received in store response. Updating all licenses in case there might have been updates anyway. Cause: [{}]", (Object)licenseRenewResponse.get(DATA));
                    this.updateLicenses();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("{} Root cause is [{}]", (Object)errorMsg, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    public void updateLicenses() {
        try {
            URL licensesUpdateURL = this.getLicensesUpdatesURL();
            if (licensesUpdateURL == null) {
                this.logger.warn("Failed to update licenses because the licensor configuration is not complete. Check your store update URL.");
                return;
            }
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            String licensesUpdateResponse = xcontext.getWiki().getURLContent(licensesUpdateURL.toString(), xcontext);
            ObjectMapper objectMapper = new ObjectMapper();
            List retrievedLicenses = (List)objectMapper.readValue(licensesUpdateResponse, Object.class);
            for (String license : retrievedLicenses) {
                License retrivedLicense = (License)this.converter.convert(License.class, (Object)this.base64decoder.decode(license));
                if (retrivedLicense == null) continue;
                ((LicenseManager)this.licenseManagerProvider.get()).add(retrivedLicense);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.logger.warn("Error while updating licenses. Root cause [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private HttpPost initializeLicenseRenewPost(ExtensionId extensionId) throws Exception {
        URI licenseRenewURL = this.getLicenseRenewURL(extensionId);
        if (licenseRenewURL == null) {
            this.logger.warn("Failed to renew license for [{}] because the licensor configuration is not complete. Check your store license renew URL and owner details.", (Object)extensionId.getId());
            return null;
        }
        HttpPost httpPost = new HttpPost(licenseRenewURL);
        List<NameValuePair> requestData = Arrays.asList(new BasicNameValuePair("firstName", this.licensingConfig.getLicensingOwnerFirstName()), new BasicNameValuePair("lastName", this.licensingConfig.getLicensingOwnerLastName()), new BasicNameValuePair("email", this.licensingConfig.getLicensingOwnerEmail()), new BasicNameValuePair(INSTANCE_ID, ((InstanceIdManager)this.instanceIdManagerProvider.get()).getInstanceId().toString()), new BasicNameValuePair(FEATURE_ID, extensionId.getId()), new BasicNameValuePair("extensionVersion", extensionId.getVersion().getValue()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(requestData));
        return httpPost;
    }

    private URI getLicenseRenewURL(ExtensionId extensionId) throws Exception {
        String storeLicenseRenewURL = this.licensingConfig.getStoreRenewURL();
        if (storeLicenseRenewURL == null) {
            return null;
        }
        URIBuilder builder = new URIBuilder(storeLicenseRenewURL);
        builder.addParameter(OUTPUT_SYNTAX, PLAIN);
        return builder.build();
    }

    private URL getLicensesUpdatesURL() throws URISyntaxException, MalformedURLException {
        String storeUpdateURL = this.licensingConfig.getStoreUpdateURL();
        if (storeUpdateURL == null) {
            return null;
        }
        URIBuilder builder = new URIBuilder(storeUpdateURL);
        builder.addParameter(INSTANCE_ID, ((InstanceIdManager)this.instanceIdManagerProvider.get()).getInstanceId().toString());
        builder.addParameter(OUTPUT_SYNTAX, PLAIN);
        for (ExtensionId paidExtensionId : this.licensedExtensionManager.getMandatoryLicensedExtensions()) {
            builder.addParameter(FEATURE_ID, paidExtensionId.getId());
            License license = ((Licensor)this.licensorProvider.get()).getLicense(paidExtensionId);
            if (license == null || License.UNLICENSED.equals((Object)license)) continue;
            builder.addParameter(String.format("expirationDate:%s", paidExtensionId.getId()), Long.toString(license.getExpirationDate()));
        }
        return builder.build().toURL();
    }
}

