/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.FileLicenseStoreReference;
import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseId;
import com.xwiki.licensing.LicenseManager;
import com.xwiki.licensing.LicenseStore;
import com.xwiki.licensing.LicenseStoreReference;
import com.xwiki.licensing.LicenseValidator;
import com.xwiki.licensing.LicensedExtensionManager;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.LicensingConfiguration;
import com.xwiki.licensing.internal.enforcer.LicensingSecurityCacheRuleInvalidator;
import com.xwiki.licensing.internal.enforcer.LicensingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;

@Component
@Singleton
public class DefaultLicenseManager
implements LicenseManager,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private LicensingConfiguration configuration;
    @Inject
    @Named(value="FileSystem")
    private LicenseStore store;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarInstalledExtensionRepository;
    @Inject
    private LicenseValidator licenseValidator;
    @Inject
    private LicensingSecurityCacheRuleInvalidator licensingSecurityCacheRuleInvalidator;
    @Inject
    private LicensedExtensionManager licensedExtensionManager;
    private final Map<LicenseId, License> licenses = new HashMap<LicenseId, License>();
    private final Map<LicenseId, Integer> licensesUsage = new HashMap<LicenseId, Integer>();
    private final Map<LicensedFeatureId, License> featureToLicense = new HashMap<LicensedFeatureId, License>();
    private final Map<ExtensionId, License> extensionToLicense = new HashMap<ExtensionId, License>();
    private LicenseStoreReference storeReference;

    public void initialize() throws InitializationException {
        if (!LicensingUtils.isPristineImpl(this.licenseValidator)) {
            this.licenseValidator = LicenseValidator.INVALIDATOR;
        }
        for (ExtensionId id : this.licensedExtensionManager.getLicensedExtensions()) {
            this.logger.debug("Mark extension [{}] as unlicensed.", (Object)id);
            this.extensionToLicense.put(id, License.UNLICENSED);
        }
        this.logger.debug("About to load registered licenses.");
        this.storeReference = new FileLicenseStoreReference(this.configuration.getLocalStorePath(), true);
        for (License license : this.store.getIterable(this.storeReference)) {
            this.logger.debug("Registering license [{}].", (Object)license.getId());
            try {
                this.linkLicenseToLicensedFeature(license);
            }
            catch (Exception e) {
                this.logger.warn("Error registering license, license has been skipped.", e.getCause());
            }
        }
        Thread linkLicenseToInstalledExtensionsThread = new Thread(new LinkLicenseToInstalledExtensionsRunnable());
        linkLicenseToInstalledExtensionsThread.setName("XWiki License Manager Initialization Thread");
        linkLicenseToInstalledExtensionsThread.setDaemon(true);
        linkLicenseToInstalledExtensionsThread.start();
    }

    private Collection<ExtensionId> linkLicenseToInstalledExtensions(Collection<LicensedFeatureId> licIds, License licenseTolink) {
        HashSet<ExtensionId> extensionIds = new HashSet<ExtensionId>();
        for (LicensedFeatureId licId : licIds) {
            extensionIds.addAll(this.linkLicenseToInstalledExtensions(licId, licenseTolink));
        }
        return extensionIds;
    }

    private Collection<ExtensionId> linkLicenseToInstalledExtensions(LicensedFeatureId licId, License licenseTolink) {
        HashSet<ExtensionId> extensionIds = new HashSet<ExtensionId>();
        License license = licenseTolink;
        for (ExtensionId extensionId : this.licensedExtensionManager.getLicensedExtensions(licId)) {
            this.logger.debug("Analyze license [{}] for extension [{}]", (Object)license.getId(), (Object)extensionId);
            License existingLicense = this.extensionToLicense.get(extensionId);
            if (existingLicense != null && license != existingLicense) {
                license = License.getOptimumLicense((License)existingLicense, (License)license);
            }
            if (license == existingLicense) continue;
            this.logger.debug("Register license [{}] for extension [{}]", (Object)license.getId(), (Object)extensionId);
            this.registerLicense(extensionId, license);
            extensionIds.add(extensionId);
        }
        return extensionIds;
    }

    private synchronized Collection<LicensedFeatureId> linkLicenseToLicensedFeature(License license) {
        ArrayList<LicensedFeatureId> licensedFeatureIds = new ArrayList<LicensedFeatureId>();
        if (this.licenseValidator.isApplicable(license) && this.licenseValidator.isSigned(license)) {
            this.logger.debug("License [{}] is applicable to this wiki instance", (Object)license.getId());
            for (LicensedFeatureId extId : license.getFeatureIds()) {
                this.logger.debug("Analyze license [{}] for feature [{}]", (Object)license.getId(), (Object)extId);
                License existingLicense = this.featureToLicense.get(extId);
                License newLicense = license;
                if (existingLicense != null) {
                    newLicense = License.getOptimumLicense((License)existingLicense, (License)license);
                }
                if (newLicense == existingLicense) continue;
                this.logger.debug("Linking license [{}] to feature [{}]", (Object)newLicense.getId(), (Object)extId);
                this.replaceLicense(extId, existingLicense, newLicense);
                licensedFeatureIds.add(extId);
            }
        } else {
            this.logger.debug("License [{}] is NOT applicable to this wiki instance", (Object)license.getId());
        }
        return licensedFeatureIds;
    }

    private void registerLicense(ExtensionId extId, License license) {
        this.extensionToLicense.put(extId, license);
        this.clearSecurityCacheForXarExtension(extId);
    }

    private void replaceLicense(LicensedFeatureId extId, License existingLicense, License newLicense) {
        this.featureToLicense.put(extId, newLicense);
        Integer usage = this.licensesUsage.get(newLicense.getId());
        if (usage == null) {
            this.logger.debug("Initialize usage of license [{}] to [1]", (Object)newLicense.getId());
            this.licenses.put(newLicense.getId(), newLicense);
            this.licensesUsage.put(newLicense.getId(), 1);
        } else {
            this.logger.debug("Increment usage of license [{}] to [{}]", (Object)newLicense.getId(), (Object)(usage + 1));
            this.licensesUsage.put(newLicense.getId(), usage + 1);
        }
        if (existingLicense != null) {
            this.logger.debug("Decrement usage of license [{}] to [{}]", (Object)existingLicense.getId(), (Object)(usage - 1));
            usage = this.licensesUsage.get(existingLicense.getId());
            this.licensesUsage.put(existingLicense.getId(), usage - 1);
            if (usage < 1) {
                this.logger.debug("Remove license [{}] from in-use licenses", (Object)existingLicense.getId());
                this.licenses.remove(existingLicense.getId());
            }
        }
    }

    void installExtensionLicense(String namespace, InstalledExtension extension) {
        ExtensionId extensionId = extension.getId();
        Collection<ExtensionId> licensedExtensions = this.licensedExtensionManager.getLicensedExtensions(namespace);
        if (licensedExtensions.contains(extensionId) && this.extensionToLicense.get(extensionId) == null) {
            this.registerLicense(extensionId, this.resolveLicenseForExtension((Extension)extension));
        }
    }

    private License resolveLicenseForExtension(Extension extension) {
        HashSet<License> candidateLicenses = new HashSet<License>();
        ExtensionId extId = extension.getId();
        Collection features = extension.getExtensionFeatures();
        block0: for (Map.Entry<LicensedFeatureId, License> entry : this.featureToLicense.entrySet()) {
            License license = entry.getValue();
            if (candidateLicenses.contains(license)) continue;
            LicensedFeatureId licId = entry.getKey();
            if (licId.isCompatible(extId)) {
                candidateLicenses.add(license);
                continue;
            }
            for (ExtensionId feature : features) {
                if (!licId.isCompatible(feature)) continue;
                candidateLicenses.add(license);
                continue block0;
            }
        }
        return candidateLicenses.size() > 0 ? License.getOptimumLicense(candidateLicenses) : License.UNLICENSED;
    }

    void uninstallExtensionLicense(InstalledExtension extension) {
        ExtensionId extensionId = extension.getId();
        if (!extension.isInstalled()) {
            this.extensionToLicense.remove(extensionId);
        }
    }

    @Override
    public License get(ExtensionId extensionId) {
        License license = this.extensionToLicense.get(extensionId);
        if (license != null) {
            return license;
        }
        ExtensionId extId = new ExtensionId(extensionId.getId());
        return this.extensionToLicense.get(extId);
    }

    @Override
    public boolean add(License license) {
        Collection<LicensedFeatureId> licIds = this.linkLicenseToLicensedFeature(license);
        if (licIds.size() > 0) {
            try {
                this.store.store(this.storeReference, license);
            }
            catch (IOException e) {
                this.logger.warn("Licensor was unable to persist license [{}].", (Object)license.getId());
            }
            this.linkLicenseToInstalledExtensions(licIds, license);
            return true;
        }
        return false;
    }

    private void clearSecurityCacheForXarExtension(ExtensionId extensionId) {
        InstalledExtension extension = this.xarInstalledExtensionRepository.getInstalledExtension(extensionId);
        if (extension != null && extension instanceof XarInstalledExtension) {
            this.logger.debug("Clearing security cache for extension [{}]", (Object)extension);
            this.licensingSecurityCacheRuleInvalidator.invalidate((XarInstalledExtension)extension);
        }
    }

    @Override
    public void delete(LicenseId licenseId) {
        this.store.delete(this.storeReference, licenseId);
    }

    @Override
    public Collection<License> getActiveLicenses() {
        return Collections.unmodifiableCollection(this.licenses.values());
    }

    @Override
    public Collection<LicenseId> getPersistedLicenses() {
        return Collections.unmodifiableCollection(this.licensesUsage.keySet());
    }

    @Override
    public Collection<LicenseId> getUnusedPersistedLicenses() {
        ArrayList<LicenseId> licenseIds = new ArrayList<LicenseId>();
        for (Map.Entry<LicenseId, Integer> entry : this.licensesUsage.entrySet()) {
            if (entry.getValue() != 0) continue;
            licenseIds.add(entry.getKey());
        }
        return licenseIds;
    }

    @Override
    public Collection<License> getUsedLicenses() {
        HashSet<License> usedLicenses = new HashSet<License>();
        for (License license : this.extensionToLicense.values()) {
            if (license == License.UNLICENSED) continue;
            usedLicenses.add(license);
        }
        return usedLicenses;
    }

    private class LinkLicenseToInstalledExtensionsRunnable
    implements Runnable {
        private LinkLicenseToInstalledExtensionsRunnable() {
        }

        @Override
        public void run() {
            Iterator<Map.Entry<LicensedFeatureId, License>> registeredLicensesIterator = DefaultLicenseManager.this.featureToLicense.entrySet().iterator();
            while (!Thread.interrupted() && registeredLicensesIterator.hasNext()) {
                Map.Entry<LicensedFeatureId, License> entry = registeredLicensesIterator.next();
                DefaultLicenseManager.this.logger.debug("Associating license [{}] for feature [{}].", (Object)entry.getValue().getId(), (Object)entry.getKey());
                DefaultLicenseManager.this.linkLicenseToInstalledExtensions(entry.getKey(), entry.getValue());
            }
            for (ExtensionId id : DefaultLicenseManager.this.licensedExtensionManager.getLicensedExtensions()) {
                if (!License.UNLICENSED.equals((Object)DefaultLicenseManager.this.extensionToLicense.get(id))) continue;
                DefaultLicenseManager.this.clearSecurityCacheForXarExtension(id);
            }
        }
    }
}

