/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.script;

import com.xwiki.licensing.FileLicenseStoreReference;
import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseStore;
import com.xwiki.licensing.LicenseStoreReference;
import com.xwiki.licensing.SignedLicense;
import com.xwiki.licensing.script.ScriptLicenseStore;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.environment.Environment;
import org.xwiki.properties.ConverterManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="licensing.license")
@Singleton
@Unstable
public class LicenseScriptService
implements ScriptService {
    @Inject
    private ConverterManager converterManager;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder encoder;
    @Inject
    private Environment environment;
    @Inject
    @Named(value="FileSystem")
    private LicenseStore filesystemLicenseStore;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public License createLicense() {
        return new License();
    }

    public ScriptLicenseStore getFileLicenseStore(String filename) {
        return this.getFileLicenseStore(filename, true);
    }

    public ScriptLicenseStore getFileLicenseStore(String filename, boolean multi) {
        return new ScriptLicenseStore(this.filesystemLicenseStore, this.getFileLicenseStoreReference(filename, multi), this.contextualAuthorizationManager);
    }

    public String encode(SignedLicense license) throws IOException {
        return this.encoder.encode(license.getEncoded(), 64);
    }

    private LicenseStoreReference getFileLicenseStoreReference(String filename, boolean multi) {
        File file = !filename.startsWith("/") ? new File(this.environment.getPermanentDirectory(), filename) : new File(filename);
        return new FileLicenseStoreReference(file, multi);
    }
}

