/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseSerializer;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.model.jaxb.FeatureIdCollection;
import com.xwiki.licensing.model.jaxb.InstanceIdCollection;
import com.xwiki.licensing.model.jaxb.LicenseType;
import com.xwiki.licensing.model.jaxb.Licensee;
import com.xwiki.licensing.model.jaxb.LicenseeMeta;
import com.xwiki.licensing.model.jaxb.ObjectFactory;
import com.xwiki.licensing.model.jaxb.Restrictions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.instance.InstanceId;

@Component
@Singleton
@Named(value="xml")
public class XmlStringLicenseSerializer
implements LicenseSerializer<String> {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64Encoder;
    private ObjectFactory objectFactory = new ObjectFactory();

    @Override
    public <G extends String> G serialize(License license) {
        return (G)this.serializeToString(license);
    }

    private String serializeToString(License license) {
        if (license.getFeatureIds().isEmpty() || license.getLicensee().isEmpty()) {
            throw new IllegalArgumentException("License could not be serialized without licensed items and licensee.");
        }
        com.xwiki.licensing.model.jaxb.License xmlLicense = this.objectFactory.createLicense().withId(license.getId().toString()).withModelVersion("2.0.0").withType(LicenseType.fromValue((String)license.getType().toString())).withLicencee(this.getLicensee(license.getLicensee())).withLicensed(this.objectFactory.createLicensedItems().withFeatures(this.getLicensedExtensionIdCollection(license)));
        Restrictions restrictions = this.getRestrictions(license);
        if (restrictions != null) {
            xmlLicense.setRestrictions(restrictions);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{com.xwiki.licensing.model.jaxb.License.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xmlLicense, (OutputStream)baos);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            this.logger.error("Error during license marshalling", (Throwable)e);
            return null;
        }
    }

    private FeatureIdCollection getLicensedExtensionIdCollection(License license) {
        FeatureIdCollection extIdsColl = this.objectFactory.createFeatureIdCollection();
        List extIds = extIdsColl.getFeatures();
        for (LicensedFeatureId id : license.getFeatureIds()) {
            extIds.add(this.objectFactory.createFeatureId().withId(id.getId()).withVersion(id.getVersionConstraint()));
        }
        return extIdsColl;
    }

    private Restrictions getRestrictions(License license) {
        if (license.getInstanceIds().isEmpty() && license.getExpirationDate() == Long.MAX_VALUE && license.getMaxUserCount() == Long.MAX_VALUE) {
            return null;
        }
        Restrictions restrictions = this.objectFactory.createRestrictions();
        if (!license.getInstanceIds().isEmpty()) {
            restrictions.setInstances(this.getInstanceIdCollection(license));
        }
        if (license.getExpirationDate() != Long.MAX_VALUE) {
            Calendar expire = Calendar.getInstance();
            expire.setTimeInMillis(license.getExpirationDate());
            restrictions.setExpire(expire);
        }
        if (license.getMaxUserCount() != Long.MAX_VALUE) {
            restrictions.setUsers(BigInteger.valueOf(license.getMaxUserCount()));
        }
        return restrictions;
    }

    private InstanceIdCollection getInstanceIdCollection(License license) {
        InstanceIdCollection instIdsColl = this.objectFactory.createInstanceIdCollection();
        List instIds = instIdsColl.getInstances();
        for (InstanceId id : license.getInstanceIds()) {
            instIds.add(id.getInstanceId());
        }
        return instIdsColl;
    }

    private Licensee getLicensee(Map<String, String> licensee) {
        LinkedHashMap<String, String> metaData = new LinkedHashMap<String, String>(licensee);
        metaData.keySet().removeAll(Arrays.asList("firstName", "lastName", "email"));
        return this.objectFactory.createLicensee().withFirstName(licensee.get("firstName")).withLastName(licensee.get("lastName")).withEmail(licensee.get("email")).withMetas((Collection)metaData.entrySet().stream().map(entry -> new LicenseeMeta().withKey((String)entry.getKey()).withValue((String)entry.getValue())).collect(Collectors.toList()));
    }
}

