/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseId;
import com.xwiki.licensing.LicenseType;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.SignedLicense;
import com.xwiki.licensing.model.jaxb.FeatureId;
import com.xwiki.licensing.model.jaxb.Licensee;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.signer.CMSSignedDataVerifier;
import org.xwiki.instance.InstanceId;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class LicenseConverter
extends AbstractConverter<License> {
    @Inject
    private Logger logger;
    @Inject
    private CMSSignedDataVerifier verifier;

    protected <G extends License> G convertToType(Type targetType, Object value) {
        if (value instanceof String) {
            return (G)this.convertToLicense((String)value);
        }
        if (value instanceof byte[]) {
            return (G)this.convertToLicense((byte[])value);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private License convertToLicense(byte[] signedLicense) {
        try {
            return new SignedLicense(signedLicense, this.verifier, (Converter<License>)this);
        }
        catch (Exception signedLicenseException) {
            String serializedLicense;
            try {
                serializedLicense = StringUtils.newStringUtf8((byte[])this.verifier.verify(signedLicense).getContent());
            }
            catch (GeneralSecurityException e) {
                throw signedLicenseException;
            }
            License license = this.convertToLicense(serializedLicense);
            this.logger.warn("The signed license [{}] will not be used because its signature is not trusted.", (Object)license.getId(), (Object)signedLicenseException);
            return license;
        }
    }

    private License convertToLicense(String serializedLicense) {
        com.xwiki.licensing.model.jaxb.License xmlLicense;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{com.xwiki.licensing.model.jaxb.License.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            xmlLicense = (com.xwiki.licensing.model.jaxb.License)jaxbUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(serializedLicense.getBytes(Charset.forName("UTF-8"))));
        }
        catch (JAXBException e) {
            throw new ConversionException(String.format("Failed to convert the following string to a license: %s", serializedLicense), (Throwable)e);
        }
        License license = new License();
        license.setId(new LicenseId(xmlLicense.getId()));
        if (xmlLicense.getType() != null) {
            license.setType(LicenseType.valueOf(xmlLicense.getType().toString()));
        }
        license.setFeatureIds(this.getLicensedExtensionIds(xmlLicense));
        license.setInstanceIds(this.getInstanceId(xmlLicense));
        if (xmlLicense.getRestrictions() != null) {
            if (xmlLicense.getRestrictions().getExpire() != null) {
                license.setExpirationDate(xmlLicense.getRestrictions().getExpire().getTimeInMillis());
            }
            if (xmlLicense.getRestrictions().getUsers() != null) {
                license.setMaxUserCount(xmlLicense.getRestrictions().getUsers().longValue());
            }
        }
        license.setLicensee(this.getLicensee(xmlLicense));
        return license;
    }

    private Collection<LicensedFeatureId> getLicensedExtensionIds(com.xwiki.licensing.model.jaxb.License xmlLicense) {
        ArrayList<LicensedFeatureId> extIds = new ArrayList<LicensedFeatureId>();
        if (xmlLicense.getLicensed() != null && xmlLicense.getLicensed().getFeatures() != null) {
            for (FeatureId id : xmlLicense.getLicensed().getFeatures().getFeatures()) {
                extIds.add(new LicensedFeatureId(id.getId(), id.getVersion()));
            }
        }
        return extIds.isEmpty() ? null : extIds;
    }

    private Collection<InstanceId> getInstanceId(com.xwiki.licensing.model.jaxb.License xmlLicense) {
        ArrayList<InstanceId> instIds = new ArrayList<InstanceId>();
        if (xmlLicense.getRestrictions() != null && xmlLicense.getRestrictions().getInstances() != null) {
            for (String id : xmlLicense.getRestrictions().getInstances().getInstances()) {
                instIds.add(new InstanceId(id));
            }
        }
        return instIds.isEmpty() ? null : instIds;
    }

    private Map<String, String> getLicensee(com.xwiki.licensing.model.jaxb.License xmlLicense) {
        HashMap<String, String> map = new HashMap<String, String>();
        Licensee licensee = xmlLicense.getLicencee();
        if (licensee != null) {
            licensee.getMetas().forEach(meta -> map.put(meta.getKey(), meta.getValue()));
            if (licensee.getName() != null) {
                String[] parts = licensee.getName().split("\\s+", 2);
                map.put("firstName", parts[0]);
                if (parts.length > 1) {
                    map.put("lastName", parts[1]);
                }
            }
            if (licensee.getFirstName() != null) {
                map.put("firstName", licensee.getFirstName());
            }
            if (licensee.getLastName() != null) {
                map.put("lastName", licensee.getLastName());
            }
            if (licensee.getEmail() != null) {
                map.put("email", licensee.getEmail());
            }
        }
        return map.isEmpty() ? null : map;
    }
}

