/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.internal;

import com.xwiki.licensing.FileLicenseStoreReference;
import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseId;
import com.xwiki.licensing.LicenseSerializer;
import com.xwiki.licensing.LicenseStore;
import com.xwiki.licensing.LicenseStoreReference;
import com.xwiki.licensing.SignedLicense;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
@Named(value="FileSystem")
public class FileSystemLicenseStore
implements LicenseStore {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte[] XML_MAGIC = new byte[]{60, 63, 120, 109, 108, 32};
    private static final String LICENSE_FILE_EXT = ".license";
    private static final FilenameFilter LICENSE_FILE_FILTER = new FilenameFilter(){
        private final Pattern pattern = Pattern.compile("[0-9a-f]{8}(?:-[0-9a-f]{4}){3}-[0-9a-f]{12}\\.license");

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).matches();
        }
    };
    @Inject
    private Logger logger;
    @Inject
    @Named(value="xml")
    private LicenseSerializer<String> serializer;
    @Inject
    private Converter<License> converter;

    private File getStoreFile(LicenseStoreReference store) {
        if (store instanceof FileLicenseStoreReference) {
            return ((FileLicenseStoreReference)store).getFile();
        }
        throw new IllegalArgumentException(String.format("Unsupported store reference [%s] for this implementation.", store.getClass().getName()));
    }

    private boolean isMulti(LicenseStoreReference store) {
        return !(store instanceof FileLicenseStoreReference) || ((FileLicenseStoreReference)store).isMulti();
    }

    private File getLicenseFile(LicenseStoreReference store, LicenseId licenseId) {
        File file = this.getStoreFile(store);
        if (!this.isMulti(store)) {
            throw new UnsupportedOperationException(String.format("Unexpected store reference, [%s] should be a multi-licenses store.", file));
        }
        return new File(file, licenseId.toString().toLowerCase() + LICENSE_FILE_EXT);
    }

    private Object getFileContent(File licenseFile) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)licenseFile);
        boolean isXML = true;
        if (data.length > XML_MAGIC.length) {
            for (int i = 0; i < XML_MAGIC.length; ++i) {
                if (data[i] == XML_MAGIC[i]) continue;
                isXML = false;
                break;
            }
        }
        if (isXML) {
            return StringUtils.newStringUtf8((byte[])data);
        }
        return data;
    }

    @Override
    public void store(LicenseStoreReference store, License license) throws IOException {
        File licenseFile;
        File file = licenseFile = this.isMulti(store) ? this.getLicenseFile(store, license.getId()) : this.getStoreFile(store);
        if (license instanceof SignedLicense) {
            FileUtils.writeByteArrayToFile((File)licenseFile, (byte[])((SignedLicense)license).getEncoded());
        } else {
            FileUtils.writeStringToFile((File)licenseFile, (String)((String)this.serializer.serialize(license)), (Charset)UTF8);
        }
    }

    @Override
    public License retrieve(LicenseStoreReference store) throws IOException {
        File licenseFile = this.getStoreFile(store);
        if (this.isMulti(store)) {
            throw new UnsupportedOperationException(String.format("Unexpected store reference, [%s] should be a single license store.", licenseFile));
        }
        if (!licenseFile.exists()) {
            return null;
        }
        return (License)this.converter.convert(License.class, this.getFileContent(licenseFile));
    }

    @Override
    public License retrieve(LicenseStoreReference store, LicenseId licenseId) throws IOException {
        File licenseFile = this.getLicenseFile(store, licenseId);
        if (!licenseFile.exists()) {
            return null;
        }
        return (License)this.converter.convert(License.class, this.getFileContent(licenseFile));
    }

    @Override
    public Iterable<License> getIterable(final LicenseStoreReference store) {
        if (!this.isMulti(store)) {
            throw new UnsupportedOperationException(String.format("Unexpected store reference, cannot iterate on a single license store [%s].", this.getStoreFile(store)));
        }
        return new Iterable<License>(){

            @Override
            public Iterator<License> iterator() {
                return new LicenseFileIterator(FileSystemLicenseStore.this.getStoreFile(store).listFiles(LICENSE_FILE_FILTER));
            }
        };
    }

    @Override
    public void delete(LicenseStoreReference store) {
        File licenseFile = this.getStoreFile(store);
        if (this.isMulti(store)) {
            try {
                FileUtils.deleteDirectory((File)licenseFile);
            }
            catch (IOException iOException) {}
        } else {
            licenseFile.delete();
        }
    }

    @Override
    public void delete(LicenseStoreReference store, LicenseId licenseId) {
        File licenseFile = this.getLicenseFile(store, licenseId);
        if (licenseFile.exists()) {
            licenseFile.delete();
        }
    }

    class LicenseFileIterator
    implements Iterator<License> {
        private final File[] files;
        private int index;
        private License next;

        LicenseFileIterator(File[] files) {
            this.files = files;
        }

        private License computeNext() {
            while (this.files != null && this.index < this.files.length) {
                File file = this.files[this.index++];
                try {
                    return (License)FileSystemLicenseStore.this.converter.convert(License.class, FileSystemLicenseStore.this.getFileContent(file));
                }
                catch (Exception e) {
                    FileSystemLicenseStore.this.logger.warn("Failed to read license file [{}].", (Object)file, (Object)e);
                }
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.computeNext();
            }
            return this.next != null;
        }

        @Override
        public License next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            License license = this.next;
            this.next = null;
            return license;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing licenses is not supported by this iterator.");
        }
    }
}

