/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing;

import com.xwiki.licensing.License;
import com.xwiki.licensing.LicenseId;
import com.xwiki.licensing.LicenseType;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.internal.LicenseConverter;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.signer.CMSSignedDataVerifier;
import org.xwiki.crypto.signer.internal.cms.DefaultCMSSignedDataVerifier;
import org.xwiki.crypto.signer.param.CMSSignedDataVerified;
import org.xwiki.crypto.signer.param.CMSSignerVerifiedInformation;
import org.xwiki.instance.InstanceId;
import org.xwiki.properties.converter.Converter;

public final class SignedLicense
extends License {
    private static final String UNSUPPORTED_METHOD_ERROR = "Signed license could not be tampered.";
    private Collection<X509CertifiedPublicKey> certificates;
    private final byte[] signedLicense;

    public SignedLicense(byte[] signedLicense, CMSSignedDataVerifier verifier, Converter<License> converter) {
        if (!(verifier instanceof DefaultCMSSignedDataVerifier) || !(converter instanceof LicenseConverter)) {
            throw new IllegalArgumentException("Untrusted signature verifier or license converter received.");
        }
        this.signedLicense = signedLicense;
        String xmlLicense = this.getTrustedContent(verifier);
        if (xmlLicense == null) {
            throw new IllegalArgumentException("Invalid signed license data received. Signature not trusted.");
        }
        License license = (License)converter.convert(License.class, (Object)xmlLicense);
        this.initialize(license);
    }

    public SignedLicense(SignedLicense license) {
        this.initialize(license);
        this.signedLicense = license.signedLicense;
    }

    public byte[] getEncoded() {
        return this.signedLicense;
    }

    private void initialize(License license) {
        super.setId(license.getId());
        super.setType(license.getType());
        super.setFeatureIds(license.getFeatureIds());
        super.setInstanceIds(license.getInstanceIds());
        super.setExpirationDate(license.getExpirationDate());
        super.setMaxUserCount(license.getMaxUserCount());
        super.setLicensee(license.getLicensee());
    }

    private String getTrustedContent(CMSSignedDataVerifier verifier) {
        CMSSignedDataVerified signedDataVerified;
        try {
            signedDataVerified = verifier.verify(this.signedLicense);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid signed license data received", e);
        }
        for (CMSSignerVerifiedInformation signatureInfo : signedDataVerified.getSignatures()) {
            this.certificates = this.getValidCertificateChain(signatureInfo);
            if (this.certificates == null) continue;
            return StringUtils.newStringUtf8((byte[])signedDataVerified.getContent());
        }
        return null;
    }

    private Collection<X509CertifiedPublicKey> getValidCertificateChain(CMSSignerVerifiedInformation signature) {
        if (!signature.isVerified()) {
            return null;
        }
        Collection chain = signature.getCertificateChain();
        if (chain == null || chain.isEmpty()) {
            return null;
        }
        CertifiedPublicKey expectedRootCA = (CertifiedPublicKey)chain.iterator().next();
        if (!(expectedRootCA instanceof X509CertifiedPublicKey)) {
            return null;
        }
        X509CertifiedPublicKey rootCA = (X509CertifiedPublicKey)expectedRootCA;
        return rootCA.isRootCA() ? this.checkChainValidity(chain) : null;
    }

    private Collection<X509CertifiedPublicKey> checkChainValidity(Collection<CertifiedPublicKey> chain) {
        ArrayList<X509CertifiedPublicKey> result = new ArrayList<X509CertifiedPublicKey>();
        for (CertifiedPublicKey cert : chain) {
            if (!(cert instanceof X509CertifiedPublicKey)) {
                return null;
            }
            if (!((X509CertifiedPublicKey)cert).isValidOn(new Date())) {
                return null;
            }
            result.add((X509CertifiedPublicKey)cert);
        }
        return result;
    }

    public Collection<X509CertifiedPublicKey> getCertificates() {
        return this.certificates;
    }

    @Override
    public void setExpirationDate(Long date) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void setFeatureIds(Collection<LicensedFeatureId> ids) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void addFeatureId(LicensedFeatureId id) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void setId(LicenseId id) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void setInstanceIds(Collection<InstanceId> ids) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void addInstanceId(InstanceId id) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void setLicensee(Map<String, String> licensee) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void addLicenseeInfo(String key, String value) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void setMaxUserCount(long userCount) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public void setType(LicenseType type) {
        throw new UnsupportedOperationException(UNSUPPORTED_METHOD_ERROR);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SignedLicense license = (SignedLicense)o;
        return new EqualsBuilder().appendSuper(super.equals(license)).append(this.getEncoded(), license.getEncoded()).isEquals();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

